/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.block.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.aksw.commons.io.block.api.Block;
import org.aksw.commons.io.block.api.PageManager;
import org.aksw.commons.io.block.impl.PageManagerForByteBuffer;
import org.aksw.commons.io.block.impl.PageNavigator;
import org.aksw.commons.io.seekable.api.Seekable;
import org.aksw.commons.util.ref.Ref;

public interface Page
extends Block {
    @Override
    public long getOffset();

    public PageManager getPageManager();

    public ByteBuffer newBuffer();

    @Override
    default public Ref<? extends Block> prevBlock() throws IOException {
        return this.getPageManager().contentAtOrBefore(this.getOffset(), false);
    }

    default public Ref<? extends Page> nextBlock() throws IOException {
        return this.getPageManager().contentAtOrAfter(this.getOffset(), false);
    }

    @Override
    default public boolean hasNext() throws IOException {
        return this.getPageManager().hasBlockAfter(this.getOffset());
    }

    @Override
    default public boolean hasPrev() throws IOException {
        return this.getPageManager().hasBlockAfter(this.getOffset());
    }

    @Override
    default public long length() throws IOException {
        return this.getPageManager().getSizeOfBlock(this.getOffset());
    }

    default public Seekable newChannel() {
        ByteBuffer buf = this.newBuffer();
        return new PageNavigator(new PageManagerForByteBuffer(buf));
    }
}

