/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.block.impl;

import java.io.IOException;
import java.util.Objects;
import org.aksw.commons.io.block.api.Block;
import org.aksw.commons.io.seekable.api.Seekable;
import org.aksw.commons.util.ref.Ref;

public class BlockEnumerator {
    public Ref<? extends Block> blockRef;
    public Block block;
    public Seekable seekable;
    protected boolean yieldSelf;
    protected boolean skipFirstClose;
    protected boolean isFwd;

    protected BlockEnumerator(boolean yieldSelf, Ref<? extends Block> blockRef, Seekable seekable, boolean isFwd, boolean skipFirstClose) {
        Objects.requireNonNull(blockRef);
        this.blockRef = blockRef;
        this.block = (Block)blockRef.get();
        this.seekable = seekable;
        this.yieldSelf = yieldSelf;
        this.skipFirstClose = skipFirstClose;
        this.isFwd = isFwd;
    }

    public Ref<? extends Block> getCurrentBlockRef() {
        return this.blockRef;
    }

    public Block getCurrentBlock() {
        return this.block;
    }

    public Seekable getCurrentSeekable() {
        return this.seekable;
    }

    public boolean hasNext() {
        boolean result;
        try {
            result = this.yieldSelf ? true : (this.isFwd ? this.block.hasNext() : this.block.hasPrev());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public void closeCurrent() {
        if (!this.skipFirstClose) {
            try {
                if (!this.blockRef.isClosed()) {
                    this.blockRef.close();
                }
                if (this.seekable.isOpen()) {
                    this.seekable.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void advance() {
        try {
            if (this.yieldSelf) {
                this.yieldSelf = false;
            } else {
                Ref<? extends Block> next;
                Ref<? extends Block> ref = next = this.isFwd ? this.block.nextBlock() : this.block.prevBlock();
                if (next != null) {
                    this.closeCurrent();
                    this.skipFirstClose = false;
                    this.blockRef = next;
                    this.block = (Block)next.get();
                    this.seekable = (Seekable)this.block.newChannel();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static BlockEnumerator fwd(boolean yieldSelf, Ref<? extends Block> blockRef, Seekable seekable) {
        return new BlockEnumerator(yieldSelf, blockRef, seekable, true, true);
    }

    public static BlockEnumerator fwd(boolean yieldSelf, Ref<? extends Block> blockRef, Seekable seekable, boolean skipFirstClose) {
        return new BlockEnumerator(yieldSelf, blockRef, seekable, true, skipFirstClose);
    }

    public static BlockEnumerator fwd(boolean yieldSelf, Ref<? extends Block> blockRef, boolean skipFirstClose) {
        return new BlockEnumerator(yieldSelf, blockRef, (Seekable)((Block)blockRef.get()).newChannel(), true, skipFirstClose);
    }

    public static BlockEnumerator bwd(boolean yieldSelf, Ref<? extends Block> blockRef, Seekable seekable) {
        return new BlockEnumerator(yieldSelf, blockRef, seekable, false, true);
    }
}

