/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.block.api;

import java.io.IOException;
import org.aksw.commons.io.block.api.BlockSource;
import org.aksw.commons.io.block.impl.Page;
import org.aksw.commons.util.ref.Ref;

public interface PageManager
extends BlockSource {
    public Ref<? extends Page> requestBufferForPage(long var1);

    public int getPageSize();

    public long getEndPos();

    @Override
    default public long size() {
        long endPos = this.getEndPos();
        int pageSize = this.getPageSize();
        long result = endPos / (long)pageSize + (long)(endPos % (long)pageSize == 0L ? 0 : 1);
        return result;
    }

    default public Ref<? extends Page> contentAtOrBefore(long pos, boolean inclusive) throws IOException {
        Ref<? extends Page> result = inclusive ? this.requestBufferForPage(pos) : (this.hasBlockBefore(pos) ? this.requestBufferForPage(pos - 1L) : null);
        return result;
    }

    default public Ref<? extends Page> contentAtOrAfter(long pos, boolean inclusive) throws IOException {
        Ref<? extends Page> result = inclusive ? this.requestBufferForPage(pos) : (this.hasBlockAfter(pos) ? this.requestBufferForPage(pos + 1L) : null);
        return result;
    }

    @Override
    default public boolean hasBlockAfter(long pos) throws IOException {
        long pageCount = this.size();
        boolean result = pos >= -1L && pos + 1L < pageCount;
        return result;
    }

    @Override
    default public boolean hasBlockBefore(long pos) throws IOException {
        long pageCount = this.size();
        boolean result = pos == pageCount || pos > 0L;
        return result;
    }

    @Override
    default public long getSizeOfBlock(long pos) throws IOException {
        int pageSize = this.getPageSize();
        long lastIndex = this.size() - 1L;
        long endPos = this.size();
        long result = pos < lastIndex ? (long)pageSize : (pos == lastIndex ? endPos % (long)pageSize : 0L);
        return result;
    }
}

