/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.binseach;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.aksw.commons.io.binseach.BinSearchScanState;
import org.aksw.commons.io.seekable.api.Seekable;

public class ReadableByteChannelForLinesMatchingPrefix
implements ReadableByteChannel {
    protected Seekable channel;
    protected BinSearchScanState state;
    protected byte delimiter = (byte)10;
    protected long currentDelimPos;
    protected long nextKnownDelimPos;

    public ReadableByteChannelForLinesMatchingPrefix(Seekable channel, BinSearchScanState state) {
        this.channel = channel;
        this.state = state;
        this.nextKnownDelimPos = this.currentDelimPos = state.firstDelimPos;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int n;
        int wanted = dst.remaining();
        long currentPos = this.channel.getPos();
        int result = 0;
        int satisfied = 0;
        try (Seekable clone = this.channel.clone();){
            while ((satisfied = Ints.checkedCast((long)(this.nextKnownDelimPos - currentPos))) < wanted) {
                long checkPos = ReadableByteChannelForLinesMatchingPrefix.nextKnownDelimPos(clone, this.delimiter, this.nextKnownDelimPos, this.state);
                if (checkPos == Long.MIN_VALUE) {
                    break;
                }
                this.nextKnownDelimPos = checkPos;
            }
        }
        if ((n = Math.min(satisfied, wanted)) <= 0) {
            if (n == -1) {
                throw new RuntimeException("Assertion failed - possible race condition");
            }
            if (wanted != 0) {
                result = -1;
            }
        } else {
            ByteBuffer adjustedDst = dst.duplicate();
            ((Buffer)adjustedDst).limit(adjustedDst.position() + n);
            int contrib = this.channel.read(adjustedDst);
            result += contrib;
        }
        return result;
    }

    public static long nextKnownDelimPos(Seekable channel, byte delimiter, long currentDelimPos, BinSearchScanState state) throws IOException {
        long result;
        if (currentDelimPos < state.matchDelimPos) {
            result = state.matchDelimPos;
        } else if (currentDelimPos + 1L >= state.size) {
            result = Long.MIN_VALUE;
        } else {
            boolean lineMatches;
            int prefixLength = state.prefixBytes.length;
            if (prefixLength != 0) {
                channel.setPos(currentDelimPos + 1L);
                lineMatches = channel.compareToPrefix(state.prefixBytes) == 0;
            } else {
                lineMatches = true;
            }
            if (lineMatches) {
                channel.nextPos(prefixLength + 1);
                channel.posToNext(delimiter);
                result = channel.getPos();
            } else {
                result = Long.MIN_VALUE;
            }
        }
        return result;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

