/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.binseach;

import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.aksw.commons.io.input.ReadableChannelSupplier;
import org.aksw.commons.io.input.ReadableChannels;

public interface BinarySearcher
extends AutoCloseable {
    public InputStream search(byte[] var1) throws IOException;

    default public InputStream search(String prefixStr) throws IOException {
        InputStream result = this.search(prefixStr == null ? null : prefixStr.getBytes());
        return result;
    }

    default public Stream<ReadableChannelSupplier<byte[]>> parallelSearch(byte[] prefix) throws IOException {
        return Stream.of(() -> {
            try {
                return ReadableChannels.wrap(this.search(prefix));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void close() throws Exception;
}

