/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.binseach;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.aksw.commons.io.binseach.BinSearchScanState;
import org.aksw.commons.io.binseach.BinarySearcher;
import org.aksw.commons.io.binseach.ReadableByteChannelForLinesMatchingPrefix;
import org.aksw.commons.io.block.impl.PageManagerForFileChannel;
import org.aksw.commons.io.block.impl.PageNavigator;
import org.aksw.commons.io.seekable.api.Seekable;

public class BinarySearchOnSortedFile
implements BinarySearcher {
    protected Seekable baseSeekable;
    protected AutoCloseable closeAction;
    protected long channelSize;
    protected byte delimiter;

    public static BinarySearchOnSortedFile create(Path path) throws IOException {
        FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
        PageManagerForFileChannel pageManager = PageManagerForFileChannel.create(channel);
        PageNavigator seekable = new PageNavigator(pageManager);
        long channelSize = channel.size();
        BinarySearchOnSortedFile result = new BinarySearchOnSortedFile(channel::close, seekable, channelSize, 10);
        return result;
    }

    public BinarySearchOnSortedFile(AutoCloseable closeAction, Seekable baseSeekable, long baseSeekableSize, byte delimiter) {
        this.baseSeekable = baseSeekable;
        this.channelSize = baseSeekableSize;
        this.delimiter = delimiter;
    }

    public static InputStream newInputStream(Seekable channel, BinSearchScanState state) {
        ReadableByteChannelForLinesMatchingPrefix tmp = new ReadableByteChannelForLinesMatchingPrefix(channel, state);
        InputStream result = Channels.newInputStream(tmp);
        return result;
    }

    @Override
    public InputStream search(String prefix) {
        try {
            return prefix == null ? new ByteArrayInputStream(new byte[0]) : this.searchCore(prefix);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream searchCore(String prefix) throws IOException {
        byte[] prefixBytes = prefix.getBytes();
        return this.search(prefixBytes);
    }

    @Override
    public InputStream search(byte[] prefixBytes) throws IOException {
        InputStream result;
        long matchDelimPos;
        Seekable seeker = this.baseSeekable.clone();
        long l = matchDelimPos = prefixBytes.length == 0 ? -1L : seeker.binarySearch(-1L, this.channelSize, this.delimiter, prefixBytes);
        if (matchDelimPos != Long.MIN_VALUE) {
            seeker.setPos(matchDelimPos);
            long posOfFirstMatch = BinarySearchOnSortedFile.getPosOfFirstMatch(seeker, this.delimiter, prefixBytes);
            seeker.setPos(posOfFirstMatch + 1L);
            BinSearchScanState state = new BinSearchScanState();
            state.size = this.channelSize;
            state.matchDelimPos = matchDelimPos;
            state.firstDelimPos = posOfFirstMatch;
            state.prefixBytes = prefixBytes;
            result = BinarySearchOnSortedFile.newInputStream(seeker, state);
        } else {
            result = new ByteArrayInputStream(new byte[0]);
        }
        return result;
    }

    public static long getPosOfFirstMatch(Seekable seekable, byte delimiter, byte[] prefix) throws IOException {
        long result = seekable.getPos();
        while (!seekable.isPosBeforeStart() && seekable.prevPos(1)) {
            if (!seekable.posToPrev(delimiter)) {
                seekable.posToStart();
            }
            seekable.nextPos(1);
            int cmp = seekable.compareToPrefix(prefix);
            if (cmp != 0) {
                seekable.setPos(result);
                break;
            }
            if (!seekable.prevPos(1)) {
                seekable.posToStart();
            }
            result = seekable.getPos();
        }
        return result;
    }

    @Override
    public void close() throws Exception {
        this.baseSeekable.close();
        if (this.closeAction != null) {
            this.closeAction.close();
        }
    }
}

