/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.index.core;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.aksw.commons.index.core.StorageNode;
import org.aksw.commons.index.core.StorageNodeListBase;
import org.aksw.commons.index.util.ListSupplier;
import org.aksw.commons.index.util.TupleValueFunction;
import org.aksw.commons.tuple.accessor.TupleAccessor;
import org.aksw.commons.tuple.bridge.TupleBridge;
import org.aksw.commons.util.stream.Streamer;

public class StorageNodeLeafDomainList<D, C, V>
extends StorageNodeListBase<D, C, V> {
    protected TupleValueFunction<C, V> valueFunction;

    public StorageNodeLeafDomainList(TupleBridge<D, C> tupleAccessor, ListSupplier listSupplier, TupleValueFunction<C, V> valueFunction) {
        super(new int[0], tupleAccessor, listSupplier);
        this.valueFunction = valueFunction;
    }

    @Override
    public boolean holdsDomainTuples() {
        return true;
    }

    public V tupleToValue(D tupleLike) {
        V result = this.valueFunction.map(tupleLike, (d, i) -> this.tupleAccessor.get(d, this.tupleIdxs[i]));
        return result;
    }

    @Override
    public List<StorageNode<D, C, ?>> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean add(List<V> list, D tupleLike) {
        V newValue = this.tupleToValue(tupleLike);
        boolean result = list != null ? list.add(newValue) : false;
        return result;
    }

    @Override
    public boolean remove(List<V> set, D tupleLike) {
        V newValue = this.tupleToValue(tupleLike);
        boolean result = set.remove(newValue);
        return result;
    }

    @Override
    public void clear(List<V> store) {
        store.clear();
    }

    public String toString() {
        return "(" + Arrays.toString(this.tupleIdxs) + ")";
    }

    @Override
    public <T> Streamer<List<V>, C> streamerForKeysAsComponent(T pattern, TupleAccessor<? super T, ? extends C> accessor) {
        throw new UnsupportedOperationException("Cannot stream keys as components if there are no keys");
    }

    @Override
    public <T> Streamer<List<V>, List<C>> streamerForKeysAsTuples(T pattern, TupleAccessor<? super T, ? extends C> accessor) {
        return argStore -> Stream.of(Collections.emptyList());
    }

    @Override
    public <T> Streamer<List<V>, V> streamerForValues(T pattern, TupleAccessor<? super T, ? extends C> accessor) {
        return argSet -> argSet.stream();
    }

    @Override
    public <T> Streamer<List<V>, ? extends Map.Entry<?, ?>> streamerForKeyAndSubStoreAlts(T pattern, TupleAccessor<? super T, ? extends C> accessor) {
        return argSet -> Stream.of(Maps.immutableEntry(Collections.emptyList(), (Object)argSet));
    }

    @Override
    public <T> Stream<V> streamEntries(List<V> list, T tupleLike, TupleAccessor<? super T, ? extends C> tupleAccessor) {
        return list.stream();
    }

    @Override
    public <T> Streamer<List<V>, ?> streamerForKeys(T pattern, TupleAccessor<? super T, ? extends C> accessor) {
        return null;
    }

    @Override
    public C getKeyComponentRaw(Object key, int idx) {
        throw new RuntimeException("Key is an empty tuple - there are no key components");
    }

    @Override
    public Object chooseSubStore(List<V> store, int subStoreIdx) {
        if (subStoreIdx != 0) {
            throw new IndexOutOfBoundsException("Index must be 0 for leaf maps");
        }
        return store;
    }
}

