/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.index.core;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.aksw.commons.index.core.StorageNode;
import org.aksw.commons.index.core.StorageNodeMapBase;
import org.aksw.commons.index.util.MapSupplier;
import org.aksw.commons.index.util.TupleValueFunction;
import org.aksw.commons.tuple.accessor.TupleAccessor;
import org.aksw.commons.tuple.bridge.TupleBridge;

public class StorageNodeLeafMap<D, C, K, V, M extends Map<K, V>>
extends StorageNodeMapBase<D, C, K, V, M> {
    protected TupleValueFunction<C, V> valueFunction;

    public StorageNodeLeafMap(int[] tupleIdxs, TupleBridge<D, C> tupleAccessor, MapSupplier mapSupplier, TupleValueFunction<C, K> keyFunction, TupleAccessor<? super K, ? extends C> keyToComponent, TupleValueFunction<C, V> valueFunction) {
        super(tupleIdxs, tupleAccessor, mapSupplier, keyFunction, keyToComponent);
        this.valueFunction = valueFunction;
    }

    @Override
    public List<StorageNode<D, C, ?>> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean add(M map, D tupleLike) {
        Object key = this.tupleToKey((Object)tupleLike);
        V newValue = this.valueFunction.map(tupleLike, this.tupleAccessor);
        if (map.containsKey(key)) {
            Object oldValue = map.get(key);
            if (!newValue.equals(oldValue)) {
                throw new RuntimeException("Insert [" + String.valueOf(newValue) + "] failed for key " + String.valueOf(key) + " because it already maps to " + String.valueOf(oldValue));
            }
        } else {
            map.put((Object)key, newValue);
        }
        return true;
    }

    @Override
    public boolean remove(M map, D tupleLike) {
        Object key = this.tupleToKey((Object)tupleLike);
        boolean result = map.containsKey(key);
        if (result) {
            map.remove(key);
        }
        return result;
    }

    @Override
    public void clear(M store) {
        store.clear();
    }

    public String toString() {
        return "leafMap(" + Arrays.toString(this.tupleIdxs) + ")";
    }

    @Override
    public <T> Stream<Map.Entry<K, ?>> streamEntries(M map, T tupleLike, TupleAccessor<? super T, ? extends C> tupleAccessor) {
        Object key;
        Object value;
        Object[] tmp = new Object[this.tupleIdxs.length];
        boolean eligibleAsKey = true;
        for (int i2 = 0; i2 < this.tupleIdxs.length; ++i2) {
            Object componentValue = tupleAccessor.get(tupleLike, i2);
            if (componentValue == null) {
                eligibleAsKey = false;
                break;
            }
            tmp[i2] = componentValue;
        }
        Stream<Object> childStream = eligibleAsKey ? ((value = map.get(key = this.keyFunction.map(tmp, (x, i) -> x[i]))) == null ? Stream.empty() : Stream.of(new AbstractMap.SimpleEntry(key, value))) : map.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), e.getValue()));
        return childStream;
    }
}

