/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.index.core;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.aksw.commons.index.core.StorageNode;
import org.aksw.commons.index.core.StorageNodeMapBase;
import org.aksw.commons.index.core.StorageNodeSetBase;
import org.aksw.commons.index.util.SetSupplier;
import org.aksw.commons.index.util.TupleValueFunction;
import org.aksw.commons.tuple.accessor.TupleAccessor;
import org.aksw.commons.tuple.bridge.TupleBridge;
import org.aksw.commons.util.stream.Streamer;

public class StorageNodeLeafComponentSet<D, C, V, S extends Set<V>>
extends StorageNodeSetBase<D, C, V, S> {
    protected TupleValueFunction<C, V> valueFunction;
    protected TupleAccessor<? super V, ? extends C> keyToComponent;

    public StorageNodeLeafComponentSet(int[] tupleIdxs, TupleBridge<D, C> tupleAccessor, SetSupplier setSupplier, TupleValueFunction<C, V> valueFunction, TupleAccessor<? super V, ? extends C> keyToComponent) {
        super(tupleIdxs, tupleAccessor, setSupplier);
        this.valueFunction = valueFunction;
        this.keyToComponent = keyToComponent;
    }

    public V tupleToValue(D tupleLike) {
        V result = this.valueFunction.map(tupleLike, (d, i) -> this.tupleAccessor.get(d, this.tupleIdxs[i]));
        return result;
    }

    @Override
    public List<StorageNode<D, C, ?>> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean add(S set, D tupleLike) {
        V newValue = this.tupleToValue(tupleLike);
        boolean result = set != null ? set.add(newValue) : false;
        return result;
    }

    @Override
    public boolean remove(S set, D tupleLike) {
        V newValue = this.tupleToValue(tupleLike);
        boolean result = set.remove(newValue);
        return result;
    }

    @Override
    public void clear(S store) {
        store.clear();
    }

    public String toString() {
        return "(" + Arrays.toString(this.tupleIdxs) + ")";
    }

    @Override
    public <T> Streamer<S, C> streamerForKeysAsComponent(T pattern, TupleAccessor<? super T, ? extends C> accessor) {
        Streamer baseStreamer = this.streamerForKeysUnderConstraints(pattern, accessor);
        return argSet -> baseStreamer.stream(argSet).map(key -> key);
    }

    public <T> Streamer<S, V> streamerForKeysUnderConstraints(T tupleLike, TupleAccessor<? super T, ? extends C> tupleAccessor) {
        Streamer result;
        Object[] keyComponents = StorageNodeMapBase.projectTupleToArray(this.tupleIdxs, tupleLike, tupleAccessor);
        if (keyComponents != null) {
            Object key = this.valueFunction.map(keyComponents, (x, i) -> x[i]);
            result = argSet -> argSet.contains(key) ? Stream.of(key) : Stream.empty();
        } else {
            result = argSet -> argSet.stream();
        }
        return result;
    }

    @Override
    public <T> Streamer<S, List<C>> streamerForKeysAsTuples(T pattern, TupleAccessor<? super T, ? extends C> accessor) {
        return null;
    }

    @Override
    public <T> Streamer<S, V> streamerForValues(T pattern, TupleAccessor<? super T, ? extends C> accessor) {
        throw new UnsupportedOperationException("There are no values to stream (Values can be seen as Tuple0 though)");
    }

    @Override
    public <T> Streamer<S, ? extends Map.Entry<?, ?>> streamerForKeyAndSubStoreAlts(T pattern, TupleAccessor<? super T, ? extends C> accessor) {
        Streamer result = this.streamerForKeysUnderConstraints(pattern, accessor).mapItems(v -> Maps.immutableEntry((Object)v, null));
        return result;
    }

    @Override
    public <T> Stream<V> streamEntries(S set, T tupleLike, TupleAccessor<? super T, ? extends C> tupleAccessor) {
        throw new UnsupportedOperationException("There are no entries to stream (Values can be seen as Tuple0 though)");
    }

    @Override
    public <T> Streamer<S, ?> streamerForKeys(T pattern, TupleAccessor<? super T, ? extends C> accessor) {
        return this.streamerForKeysUnderConstraints(pattern, accessor);
    }

    @Override
    public C getKeyComponentRaw(Object key, int idx) {
        Object result = this.keyToComponent.get(key, idx);
        return (C)result;
    }

    @Override
    public Object chooseSubStore(S store, int subStoreIdx) {
        if (subStoreIdx != 0) {
            throw new IndexOutOfBoundsException("Index must be 0 for inner maps");
        }
        return store;
    }
}

