/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.index.core;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.index.core.StorageNode;
import org.aksw.commons.index.core.StorageNodeAltBase;
import org.aksw.commons.index.core.StorageNodeMutable;
import org.aksw.commons.index.util.Alt3;
import org.aksw.commons.tuple.accessor.TupleAccessor;
import org.aksw.commons.tuple.bridge.TupleBridge;

public class StorageNodeAlt3<D, C, V1, V2, V3>
extends StorageNodeAltBase<D, C, Alt3<V1, V2, V3>>
implements StorageNodeMutable<D, C, Alt3<V1, V2, V3>> {
    protected Alt3<? extends StorageNodeMutable<D, C, V1>, ? extends StorageNodeMutable<D, C, V2>, ? extends StorageNodeMutable<D, C, V3>> children;

    public StorageNodeAlt3(TupleBridge<D, C> tupleAccessor, StorageNodeMutable<D, C, V1> child1, StorageNodeMutable<D, C, V2> child2, StorageNodeMutable<D, C, V3> child3) {
        super(tupleAccessor);
        this.children = Alt3.create(child1, child2, child3);
    }

    @Override
    public List<? extends StorageNode<D, C, ?>> getChildren() {
        return Arrays.asList(this.children.getV1(), this.children.getV2(), this.children.getV3());
    }

    @Override
    public <T> Stream<?> streamEntries(Alt3<V1, V2, V3> childStores, T tupleLike, TupleAccessor<? super T, ? extends C> tupleAccessor) {
        StorageNodeMutable<D, ? extends C, V1> pickedChild = this.children.getV1();
        V1 pickedChildStore = childStores.getV1();
        return pickedChild.streamEntriesRaw(pickedChildStore, tupleLike, tupleAccessor);
    }

    @Override
    public Alt3<V1, V2, V3> newStore() {
        return Alt3.create(this.children.getV1().newStore(), this.children.getV2().newStore(), this.children.getV3().newStore());
    }

    @Override
    public boolean isEmpty(Alt3<V1, V2, V3> childStores) {
        StorageNodeMutable<D, C, V1> pickedChild = this.children.getV1();
        V1 pickedChildStore = childStores.getV1();
        boolean result = pickedChild.isEmptyRaw(pickedChildStore);
        return result;
    }

    @Override
    public boolean add(Alt3<V1, V2, V3> childStores, D tupleLike) {
        boolean result = false;
        result = result || this.children.getV1().add(childStores.getV1(), tupleLike);
        this.children.getV2().add(childStores.getV2(), tupleLike);
        this.children.getV3().add(childStores.getV3(), tupleLike);
        return result;
    }

    @Override
    public boolean remove(Alt3<V1, V2, V3> childStores, D tupleLike) {
        boolean result = this.children.getV1().remove(childStores.getV1(), tupleLike);
        this.children.getV2().remove(childStores.getV2(), tupleLike);
        this.children.getV3().remove(childStores.getV3(), tupleLike);
        return result;
    }

    @Override
    public Object chooseSubStore(Alt3<V1, V2, V3> store, int subStoreIdx) {
        return switch (subStoreIdx) {
            case 0 -> store.getV1();
            case 1 -> store.getV2();
            case 2 -> store.getV3();
            default -> throw new IndexOutOfBoundsException("Index must be 0 or 1; was " + subStoreIdx);
        };
    }

    @Override
    public void clear(Alt3<V1, V2, V3> store) {
        this.children.getV1().clear(store.getV1());
        this.children.getV2().clear(store.getV2());
        this.children.getV3().clear(store.getV3());
    }

    public String toString() {
        return "alt3(" + this.getChildren().stream().map(Object::toString).collect(Collectors.joining(" |\n")) + ")";
    }
}

