/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.index.core;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.index.core.StorageNode;
import org.aksw.commons.index.core.StorageNodeAltBase;
import org.aksw.commons.index.core.StorageNodeMutable;
import org.aksw.commons.tuple.accessor.TupleAccessor;
import org.aksw.commons.tuple.bridge.TupleBridge;

public class StorageNodeAltN<D, C>
extends StorageNodeAltBase<D, C, Object[]>
implements StorageNodeMutable<D, C, Object[]> {
    protected List<? extends StorageNodeMutable<D, C, ?>> children;

    public StorageNodeAltN(TupleBridge<D, C> tupleAccessor, List<? extends StorageNodeMutable<D, C, ?>> children) {
        super(tupleAccessor);
        this.children = children;
    }

    @Override
    public List<? extends StorageNode<D, C, ?>> getChildren() {
        return this.children;
    }

    @Override
    public <T> Stream<?> streamEntries(Object[] childStores, T tupleLike, TupleAccessor<? super T, ? extends C> tupleAccessor) {
        StorageNodeMutable<D, ? extends C, ?> pickedChild = this.children.get(0);
        Object pickedChildStore = childStores[0];
        return pickedChild.streamEntriesRaw(pickedChildStore, tupleLike, tupleAccessor);
    }

    @Override
    public Object[] newStore() {
        Object[] result = new Object[this.children.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.children.get(i).newStore();
        }
        return result;
    }

    @Override
    public boolean isEmpty(Object[] childStores) {
        StorageNodeMutable<D, C, ?> pickedChild = this.children.get(0);
        Object pickedChildStore = childStores[0];
        boolean result = pickedChild.isEmptyRaw(pickedChildStore);
        return result;
    }

    @Override
    public boolean add(Object[] childStores, D tupleLike) {
        boolean result = false;
        for (int i = 0; i < this.children.size(); ++i) {
            StorageNodeMutable<D, C, ?> child = this.children.get(i);
            Object childStore = childStores[i];
            result = child.addRaw(childStore, tupleLike);
        }
        return result;
    }

    @Override
    public boolean remove(Object[] childStores, D tupleLike) {
        boolean result = false;
        for (int i = 0; i < this.children.size(); ++i) {
            StorageNodeMutable<D, C, ?> child = this.children.get(i);
            Object childStore = childStores[i];
            result = child.removeRaw(childStore, tupleLike);
        }
        return result;
    }

    @Override
    public void clear(Object[] childStores) {
        for (int i = 0; i < this.children.size(); ++i) {
            StorageNodeMutable<D, C, ?> child = this.children.get(i);
            Object childStore = childStores[i];
            child.clearRaw(childStore);
        }
    }

    public String toString() {
        return "altN(" + this.children.stream().map(Object::toString).collect(Collectors.joining(" |\n")) + ")";
    }

    @Override
    public Object chooseSubStore(Object[] store, int subStoreIdx) {
        return store[subStoreIdx];
    }
}

