/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.index;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.aksw.commons.index.TupleCodec;
import org.aksw.commons.tuple.bridge.TupleBridge;

public abstract class TupleCodecDictionary<D1, C1, D2, C2>
implements TupleCodec<D1, C1, D2, C2> {
    protected BiMap<C1, C2> dictionary = HashBiMap.create();
    protected TupleBridge<D1, C1> sourceTupleAccessor;
    protected TupleBridge<D2, C2> targetTupleAccessor;

    public TupleCodecDictionary(TupleBridge<D1, C1> sourceTupleAccessor, TupleBridge<D2, C2> targetTupleAccessor) {
        this.sourceTupleAccessor = sourceTupleAccessor;
        this.targetTupleAccessor = targetTupleAccessor;
    }

    protected abstract C2 makeEntry(C1 var1);

    public static <D, C> TupleCodec<D, C, int[], Integer> createForInts(TupleBridge<D, C> source, TupleBridge<int[], Integer> target) {
        return new TupleCodecDictionary<D, C, int[], Integer>((TupleBridge)source, (TupleBridge)target){

            @Override
            protected Integer makeEntry(C c1) {
                int r = this.dictionary.size();
                this.dictionary.put(c1, (Object)r);
                return r;
            }
        };
    }

    @Override
    public C2 getEncodedComponent(D1 d1, int idx) {
        Object c1 = this.sourceTupleAccessor.get(d1, idx);
        C2 result = this.encodeComponent(c1);
        return result;
    }

    @Override
    public C1 getDecodedComponent(D2 d2, int idx) {
        Object c2 = this.targetTupleAccessor.get(d2, idx);
        C1 result = this.decodeComponent(c2);
        return result;
    }

    @Override
    public TupleBridge<D1, C1> getSourceTupleAccessor() {
        return this.sourceTupleAccessor;
    }

    @Override
    public TupleBridge<D2, C2> getTargetTupleAccessor() {
        return this.targetTupleAccessor;
    }

    @Override
    public C2 encodeComponent(C1 c1) {
        Object result = this.dictionary.computeIfAbsent(c1, c -> this.makeEntry(c));
        return (C2)result;
    }

    @Override
    public C1 decodeComponent(C2 c2) {
        Object result = this.dictionary.inverse().get(c2);
        return (C1)result;
    }

    @Override
    public D2 encodeTuple(D1 sourceTuple) {
        Object result = this.targetTupleAccessor.build(sourceTuple, (st, i) -> {
            Object c1 = this.sourceTupleAccessor.get(st, i);
            C2 c2 = this.encodeComponent(c1);
            return c2;
        });
        return (D2)result;
    }

    @Override
    public D1 decodeTuple(D2 targetTuple) {
        Object result = this.sourceTupleAccessor.build(targetTuple, (tt, i) -> {
            Object c2 = this.targetTupleAccessor.get(tt, i);
            Object c1 = this.dictionary.inverse().get(c2);
            return c1;
        });
        return (D1)result;
    }
}

