/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.index;

import com.google.common.collect.HashBiMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.aksw.commons.index.TupleCodec;
import org.aksw.commons.index.TupleCodecCanonical;
import org.aksw.commons.index.core.StorageNodeAlt2;
import org.aksw.commons.index.core.StorageNodeAlt3;
import org.aksw.commons.index.core.StorageNodeAltN;
import org.aksw.commons.index.core.StorageNodeDictionary;
import org.aksw.commons.index.core.StorageNodeInnerMap;
import org.aksw.commons.index.core.StorageNodeLeafComponentSet;
import org.aksw.commons.index.core.StorageNodeLeafDomainList;
import org.aksw.commons.index.core.StorageNodeLeafDomainSet;
import org.aksw.commons.index.core.StorageNodeLeafMap;
import org.aksw.commons.index.core.StorageNodeMutable;
import org.aksw.commons.index.core.StorageNodeMutableForwardingBase;
import org.aksw.commons.index.core.StorageNodeWrapperCodec;
import org.aksw.commons.index.util.Alt2;
import org.aksw.commons.index.util.Alt3;
import org.aksw.commons.index.util.ListSupplier;
import org.aksw.commons.index.util.MapSupplier;
import org.aksw.commons.index.util.SetSupplier;
import org.aksw.commons.index.util.TupleValueFunction;
import org.aksw.commons.tuple.bridge.TupleBridge;

public class StorageComposers {
    public static <D, C, S extends Set<D>> StorageNodeMutable<D, C, S> leafSet(SetSupplier setSupplier, TupleBridge<D, C> tupleAccessor) {
        return new StorageNodeLeafDomainSet(tupleAccessor, setSupplier, TupleValueFunction.newIdentity());
    }

    public static <D, C, S extends Set<C>> StorageNodeMutable<D, C, S> leafComponentSet(int tupleIdx, SetSupplier setSupplier, TupleBridge<D, C> tupleAccessor) {
        return new StorageNodeLeafComponentSet(new int[]{tupleIdx}, tupleAccessor, setSupplier, TupleValueFunction::component0, (key, idx) -> key);
    }

    public static <D, C> StorageNodeMutable<D, C, List<D>> leafList(ListSupplier listSupplier, TupleBridge<D, C> tupleAccessor) {
        return new StorageNodeLeafDomainList(tupleAccessor, listSupplier, TupleValueFunction.newIdentity());
    }

    public static <D, C, S extends Map<C, D>> StorageNodeMutable<D, C, S> leafMap(int tupleIdx, MapSupplier mapSupplier, TupleBridge<D, C> tupleAccessor) {
        return new StorageNodeLeafMap(new int[]{tupleIdx}, tupleAccessor, mapSupplier, TupleValueFunction::component0, (key, idx) -> key, TupleValueFunction.newIdentity());
    }

    public static <D, C, V, S extends Map<C, V>> StorageNodeMutable<D, C, S> innerMap(int tupleIdx, MapSupplier mapSupplier, StorageNodeMutable<D, C, V> child) {
        TupleBridge tupleAccessor = child.getTupleAccessor();
        return new StorageNodeInnerMap(new int[]{tupleIdx}, tupleAccessor, child, mapSupplier, TupleValueFunction::component0, (key, idx) -> key);
    }

    public static <D, C> StorageNodeMutable<D, C, ?> altN(List<? extends StorageNodeMutable<D, C, ?>> children) {
        if (children.isEmpty()) {
            throw new IllegalArgumentException("At least one alternative must be provided");
        }
        TupleBridge tupleAccessor = children.get(0).getTupleAccessor();
        return new StorageNodeAltN(tupleAccessor, children);
    }

    public static <D, C, V1, V2> StorageNodeMutable<D, C, Alt2<V1, V2>> alt2(StorageNodeMutable<D, C, V1> child1, StorageNodeMutable<D, C, V2> child2) {
        TupleBridge tupleAccessor = child1.getTupleAccessor();
        return new StorageNodeAlt2(tupleAccessor, child1, child2);
    }

    public static <D, C, V1, V2, V3> StorageNodeMutable<D, C, Alt3<V1, V2, V3>> alt3(StorageNodeMutable<D, C, V1> child1, StorageNodeMutable<D, C, V2> child2, StorageNodeMutable<D, C, V3> child3) {
        TupleBridge tupleAccessor = child1.getTupleAccessor();
        return new StorageNodeAlt3(tupleAccessor, child1, child2, child3);
    }

    public static <D, C, V> StorageNodeMutable<D, C, V> postProcessAdd(StorageNodeMutable<D, C, V> delegate, final BiConsumer<V, D> postProcessor) {
        return new StorageNodeMutableForwardingBase<D, C, V, StorageNodeMutable<D, C, V>>(delegate){

            @Override
            public boolean add(V store, D tupleLike) {
                boolean result = super.add(store, tupleLike);
                postProcessor.accept(store, tupleLike);
                return result;
            }
        };
    }

    public static <D, C, V, X extends StorageNodeMutable<D, C, V>> StorageNodeWrapperCodec<D, C, V, X> wrapWithCanonicalization(X delegate) {
        TupleCodec tupleCodec = TupleCodecCanonical.create(delegate.getTupleAccessor());
        return new StorageNodeWrapperCodec(delegate, tupleCodec);
    }

    public static <D1, C1, D2, C2, V, X extends StorageNodeMutable<D2, C2, V>> StorageNodeMutable<D1, C1, V> wrapWithDictionary(X delegate, TupleBridge<D1, C1> sourceTupleAccessor) {
        return new StorageNodeDictionary(delegate, HashBiMap.create(), sourceTupleAccessor, delegate.getTupleAccessor());
    }
}

