/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.codec.entity.impl;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.aksw.commons.codec.entity.api.EntityTransform;

public class EntityTransformCoalesce<T>
implements EntityTransform<T> {
    protected Collection<? extends EntityTransform<T>> transforms;

    public EntityTransformCoalesce(Collection<? extends EntityTransform<T>> transforms) {
        this.transforms = transforms;
    }

    @Override
    public boolean canApply(T entity) {
        boolean result = this.findApplicableTransforms(entity).findAny().isPresent();
        return result;
    }

    @Override
    public T apply(T entity) {
        EntityTransform<T> xform = this.tryGetFirstApplicableTransform(entity).orElseThrow(() -> new RuntimeException("No applicable transform found for " + String.valueOf(entity)));
        Object result = xform.apply(entity);
        return (T)result;
    }

    public Optional<EntityTransform<T>> tryGetFirstApplicableTransform(T entity) {
        return this.findApplicableTransforms(entity).findFirst();
    }

    public EntityTransform<T> getFirstApplicableTransform(T entity) {
        return this.tryGetFirstApplicableTransform(entity).orElse(null);
    }

    public Stream<EntityTransform<T>> findApplicableTransforms(T entity) {
        return this.transforms.stream().filter(xform -> {
            boolean r = xform.canApply(entity);
            return r;
        }).map(x -> x);
    }

    public static <T> EntityTransformCoalesce<T> create(Collection<? extends EntityTransform<T>> transforms) {
        return new EntityTransformCoalesce<T>(transforms);
    }
}

