/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.codec.string.impl;

import java.util.regex.Pattern;
import org.aksw.commons.codec.string.api.StringCodecDirectBase;

public class StringCodecQuote
implements StringCodecDirectBase {
    protected final char quoteChar;
    protected final char escapeChar;

    public StringCodecQuote(char quoteChar, char escapeChar) {
        this.quoteChar = quoteChar;
        this.escapeChar = escapeChar;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    @Override
    public String encode(String entity) {
        String escaped = entity.replace("" + this.escapeChar, "" + this.escapeChar + this.escapeChar).replace("" + this.quoteChar, "" + this.escapeChar + this.quoteChar);
        String result = this.quoteChar + escaped + this.quoteChar;
        return result;
    }

    @Override
    public boolean canDecode(String entity) {
        boolean result = entity.startsWith("" + this.quoteChar) && entity.endsWith("" + this.quoteChar);
        return result;
    }

    @Override
    public String decode(String entity) {
        if (!this.canDecode(entity)) {
            throw new IllegalArgumentException(String.format("Cannot decode %s with quote char %c and escape char", entity, Character.valueOf(this.quoteChar), Character.valueOf(this.escapeChar)));
        }
        String result = entity.substring(1, entity.length() - 1).replaceAll(Pattern.quote("" + this.escapeChar) + "(.)", "$1");
        return result;
    }

    public static StringCodecQuote create(char quoteChar) {
        return StringCodecQuote.create(quoteChar, '\\');
    }

    public static StringCodecQuote create(char quoteChar, char escapeChar) {
        return new StringCodecQuote(quoteChar, escapeChar);
    }
}

