/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.codec.string.impl;

import org.aksw.commons.codec.string.api.StringCodecDirectBase;

public class StringCodecPrefixAndSuffix
implements StringCodecDirectBase {
    protected final String prefix;
    protected final String suffix;

    public StringCodecPrefixAndSuffix(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public String encode(String entity) {
        String result = this.prefix + entity + this.suffix;
        return result;
    }

    @Override
    public boolean canDecode(String entity) {
        boolean result = entity.startsWith(this.prefix) && entity.endsWith(this.suffix);
        return result;
    }

    @Override
    public String decode(String entity) {
        if (!this.canDecode(entity)) {
            throw new IllegalArgumentException(String.format("Cannot decode %s with prefix=%s and suffix=%s", entity, this.prefix, this.suffix));
        }
        String result = entity.substring(this.prefix.length(), entity.length() - this.suffix.length());
        return result;
    }

    public static StringCodecPrefixAndSuffix create(String prefixAndSuffix) {
        return StringCodecPrefixAndSuffix.create(prefixAndSuffix, prefixAndSuffix);
    }

    public static StringCodecPrefixAndSuffix create(String prefix, String suffix) {
        return new StringCodecPrefixAndSuffix(prefix, suffix);
    }
}

