/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.codec.entity.util;

import java.util.function.Supplier;
import org.aksw.commons.codec.entity.api.EntityCodec;

public class EntityCodecUtils {
    public static <T> T harmonize(T entity, Supplier<? extends EntityCodec<T>> codecSupplier) {
        EntityCodec<T> codec = codecSupplier.get();
        T result = EntityCodecUtils.harmonize(entity, codec);
        return result;
    }

    public static <T> T harmonize(T entity, EntityCodec<T> codec) {
        T canonicalEntity = entity;
        if (codec.canDecode(canonicalEntity)) {
            canonicalEntity = codec.decode(canonicalEntity);
        }
        T result = codec.encode(canonicalEntity);
        return result;
    }

    public static <T> T reencode(T entity, Supplier<? extends EntityCodec<T>> decodecSupplier, Supplier<? extends EntityCodec<T>> encodecSupplier) {
        EntityCodec<T> decodec = decodecSupplier.get();
        EntityCodec<T> encodec = encodecSupplier.get();
        T result = EntityCodecUtils.reencode(entity, decodec, encodec);
        return result;
    }

    public static <T> T reencode(T entity, EntityCodec<T> decodec, EntityCodec<T> encodec) {
        T result;
        if (decodec.canDecode(entity)) {
            T tmp = decodec.decode(entity);
            result = encodec.encode(tmp);
        } else {
            result = entity;
        }
        return result;
    }
}

