/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.core;

import java.io.Serializable;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.ParallelAggregator;

public class AggReduce<I, E>
implements ParallelAggregator<I, E, I, Accumulator<I, E, I>>,
Serializable {
    private static final long serialVersionUID = 0L;
    protected Supplier<I> zeroElementSupplier;
    protected BinaryOperator<I> plusOperator;

    public AggReduce(Supplier<I> zeroElementSupplier, BinaryOperator<I> plusOperator) {
        this.zeroElementSupplier = zeroElementSupplier;
        this.plusOperator = plusOperator;
    }

    @Override
    public Accumulator<I, E, I> createAccumulator() {
        I zeroElement = this.zeroElementSupplier.get();
        return new AccReduceImpl(zeroElement);
    }

    @Override
    public Accumulator<I, E, I> combine(Accumulator<I, E, I> a, Accumulator<I, E, I> b) {
        I va = a.getValue();
        I vb = b.getValue();
        Object combinedValue = this.plusOperator.apply(va, vb);
        return new AccReduceImpl(combinedValue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.plusOperator == null ? 0 : this.plusOperator.hashCode());
        result = 31 * result + (this.zeroElementSupplier == null ? 0 : this.zeroElementSupplier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggReduce other = (AggReduce)obj;
        if (this.plusOperator == null ? other.plusOperator != null : !this.plusOperator.equals(other.plusOperator)) {
            return false;
        }
        return !(this.zeroElementSupplier == null ? other.zeroElementSupplier != null : !this.zeroElementSupplier.equals(other.zeroElementSupplier));
    }

    public class AccReduceImpl
    implements Accumulator<I, E, I>,
    Serializable {
        private static final long serialVersionUID = 0L;
        protected I value;

        public AccReduceImpl(I value) {
            this.value = value;
        }

        @Override
        public void accumulate(I input, E env) {
            this.value = AggReduce.this.plusOperator.apply(this.value, input);
        }

        @Override
        public I getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccReduceImpl other = (AccReduceImpl)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        private AggReduce<?, ?> getEnclosingInstance() {
            return AggReduce.this;
        }
    }
}

