/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.core;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.Aggregator;

public class AggFinish<B, I, E, O, C extends Aggregator<B, E, I>>
implements Aggregator<B, E, O>,
Serializable {
    private static final long serialVersionUID = 1L;
    private C subAgg;
    private Function<? super I, O> transform;

    public AggFinish(C subAgg, Function<? super I, O> transform) {
        this.subAgg = subAgg;
        this.transform = transform;
    }

    @Override
    public Accumulator<B, E, O> createAccumulator() {
        Accumulator baseAcc = this.subAgg.createAccumulator();
        AccFinish result = new AccFinish(baseAcc, this.transform);
        return result;
    }

    public C getSubAgg() {
        return this.subAgg;
    }

    public Function<? super I, O> getTransform() {
        return this.transform;
    }

    public static <B, I, E, O, C extends Aggregator<B, E, I>> AggFinish<B, I, E, O, C> create(C subAgg, Function<? super I, O> transform) {
        AggFinish<B, ? super I, E, O, C> result = new AggFinish<B, I, E, O, C>(subAgg, transform);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.subAgg == null ? 0 : this.subAgg.hashCode());
        result = 31 * result + (this.transform == null ? 0 : this.transform.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggFinish other = (AggFinish)obj;
        if (this.subAgg == null ? other.subAgg != null : !this.subAgg.equals(other.subAgg)) {
            return false;
        }
        return !(this.transform == null ? other.transform != null : !this.transform.equals(other.transform));
    }

    public static class AccFinish<I, E, O, V>
    implements Accumulator<I, E, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected Accumulator<I, E, O> subAcc;
        protected Function<? super O, V> transform;

        public AccFinish(Accumulator<I, E, O> subAcc, Function<? super O, V> transform) {
            this.subAcc = subAcc;
            this.transform = transform;
        }

        @Override
        public void accumulate(I input, E env) {
            this.subAcc.accumulate(input, env);
        }

        public Accumulator<I, E, O> getSubAcc() {
            return this.subAcc;
        }

        @Override
        public V getValue() {
            O accValue = this.subAcc.getValue();
            V result = this.transform.apply(accValue);
            return result;
        }

        public Function<? super O, V> getTransform() {
            return this.transform;
        }

        public int hashCode() {
            return Objects.hash(this.subAcc, this.transform);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccFinish other = (AccFinish)obj;
            return Objects.equals(this.subAcc, other.subAcc) && Objects.equals(this.transform, other.transform);
        }
    }
}

