/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.core;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class SetOverMap<K, V>
extends AbstractSet<Map.Entry<K, V>> {
    protected Map<K, V> delegate;

    SetOverMap() {
    }

    public SetOverMap(Map<K, V> delegate) {
        this.delegate = delegate;
    }

    public Map<K, V> getMap() {
        return this.delegate;
    }

    @Override
    public boolean add(Map.Entry<K, V> e) {
        Objects.requireNonNull(e, "Entry must not be null");
        K key = e.getKey();
        V now = e.getValue();
        V old = this.delegate.put(key, now);
        boolean result = !Objects.equals(now, old);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        Map.Entry k;
        boolean result = false;
        if (o instanceof Map.Entry && (result = this.delegate.containsKey(k = (Map.Entry)o))) {
            this.delegate.remove(k);
        }
        return result;
    }

    @Override
    public boolean contains(Object o) {
        Map.Entry e;
        Object k;
        boolean result = false;
        if (o instanceof Map.Entry && this.delegate.containsKey(k = (e = (Map.Entry)o).getKey())) {
            V v = this.delegate.get(k);
            result = Objects.equals(v, e.getValue());
        }
        return result;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.delegate.entrySet().iterator();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetOverMap other = (SetOverMap)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
    }

    @Override
    public String toString() {
        return "SetOverMap [delegate=" + String.valueOf(this.delegate) + "]";
    }
}

