/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collector;
import org.aksw.commons.collector.core.AccCollection;
import org.aksw.commons.collector.core.AggCounting;
import org.aksw.commons.collector.core.AggErrorHandler;
import org.aksw.commons.collector.core.AggFromCollector;
import org.aksw.commons.collector.core.AggInputBroadcast;
import org.aksw.commons.collector.core.AggInputBroadcastMap;
import org.aksw.commons.collector.core.AggInputFilter;
import org.aksw.commons.collector.core.AggInputFlatMap;
import org.aksw.commons.collector.core.AggInputSplit;
import org.aksw.commons.collector.core.AggInputTransform;
import org.aksw.commons.collector.core.AggNatural;
import org.aksw.commons.collector.core.AggOutputTransform;
import org.aksw.commons.collector.core.AggReduce;
import org.aksw.commons.collector.core.SerializableCollectorImpl;
import org.aksw.commons.collector.core.SetOverMap;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.ParallelAggregator;
import org.aksw.commons.lambda.serializable.SerializableBiConsumer;
import org.aksw.commons.lambda.serializable.SerializableBiFunction;
import org.aksw.commons.lambda.serializable.SerializableBinaryOperator;
import org.aksw.commons.lambda.serializable.SerializableCollector;
import org.aksw.commons.lambda.serializable.SerializableConsumer;
import org.aksw.commons.lambda.serializable.SerializableFunction;
import org.aksw.commons.lambda.serializable.SerializablePredicate;
import org.aksw.commons.lambda.serializable.SerializableSupplier;
import org.aksw.commons.lambda.serializable.SerializableToDoubleFunction;
import org.aksw.commons.lambda.serializable.SerializableToIntFunction;
import org.aksw.commons.lambda.serializable.SerializableToLongFunction;
import org.aksw.commons.util.serializable.SerializableDoubleSummaryStatistics;
import org.aksw.commons.util.serializable.SerializableIntSummaryStatistics;
import org.aksw.commons.util.serializable.SerializableLongSummaryStatistics;

public class AggBuilder<I, E, O, ACC extends Accumulator<I, E, O>, AGG extends ParallelAggregator<I, E, O, ACC>> {
    static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));

    public static <I, E, O, ACC extends Accumulator<I, E, O>, AGG extends ParallelAggregator<I, E, O, ACC>> AggInputFilter<I, E, O, ACC, AGG> inputFilter(SerializablePredicate<? super I> inputFilter, AGG state) {
        return new AggInputFilter(state, inputFilter);
    }

    public static <I, E, K, J, O, ACC extends Accumulator<J, E, O>, AGG extends ParallelAggregator<J, E, O, ACC>> AggInputSplit<I, E, K, J, O, ACC, AGG> inputSplit(SerializableFunction<? super I, ? extends Set<? extends K>> keyMapper, SerializableBiFunction<? super I, ? super K, ? extends J> valueMapper, AGG state) {
        return new AggInputSplit(state, keyMapper, valueMapper);
    }

    public static <I, E, K, J, O, ACC extends Accumulator<J, E, O>, AGG extends ParallelAggregator<J, E, O, ACC>> AggInputSplit<I, E, K, J, O, ACC, AGG> inputSplit(Set<K> fixedKeys, boolean considerNewKeys, SerializableFunction<? super I, ? extends Set<? extends K>> keyMapper, SerializableBiFunction<? super I, ? super K, ? extends J> valueMapper, AGG state) {
        return new AggInputSplit(state, fixedKeys, considerNewKeys, keyMapper, valueMapper);
    }

    public static <I, E, K, O, ACC extends Accumulator<I, E, O>, AGG extends ParallelAggregator<I, E, O, ACC>> AggInputSplit<I, E, K, I, O, ACC, AGG> inputSplit(SerializableFunction<? super I, ? extends K> keyMapper, AGG state) {
        return new AggInputSplit(state, in -> Collections.singleton(keyMapper.apply(in)), (in, key) -> in);
    }

    public static <I, E, J, O, ACC extends Accumulator<J, E, O>, AGG extends ParallelAggregator<J, E, O, ACC>> AggInputTransform<I, E, J, O, ACC, AGG> inputTransform(SerializableFunction<? super I, ? extends J> inputTransform, AGG state) {
        SerializableBiFunction & Serializable fn2 = (SerializableBiFunction & Serializable)(i, e) -> inputTransform.apply(i);
        return AggBuilder.inputTransform2(fn2, state);
    }

    public static <I, E, J, O, ACC extends Accumulator<J, E, O>, AGG extends ParallelAggregator<J, E, O, ACC>> AggInputTransform<I, E, J, O, ACC, AGG> inputTransform2(SerializableBiFunction<? super I, E, ? extends J> inputTransform, AGG state) {
        return new AggInputTransform(state, inputTransform);
    }

    public static <I, E, O, ACC extends Accumulator<I, E, O>, AGG extends ParallelAggregator<I, E, O, ACC>> AggErrorHandler<I, E, O, ACC, AGG> errorHandler(AGG state) {
        return new AggErrorHandler(state, false, null, null);
    }

    public static <I, E, O, ACC extends Accumulator<I, E, O>, AGG extends ParallelAggregator<I, E, O, ACC>> AggErrorHandler<I, E, O, ACC, AGG> errorHandler(AGG state, boolean accDespiteError, SerializableConsumer<? super Throwable> errorCallback, SerializableFunction<AggErrorHandler.AccError<I, E, O, ACC>, O> errorValueExtractor) {
        return new AggErrorHandler<I, E, O, ACC, AGG>(state, accDespiteError, (Consumer<Throwable>)errorCallback, errorValueExtractor);
    }

    public static <I, E, J, O, ACC extends Accumulator<J, E, O>, AGG extends ParallelAggregator<J, E, O, ACC>> AggInputFlatMap<I, E, J, O, ACC, AGG> inputFlatMap(SerializableFunction<I, ? extends Iterator<? extends J>> inputTransform, AGG state) {
        SerializableBiFunction & Serializable fn2 = (SerializableBiFunction & Serializable)(i, e) -> (Iterator)inputTransform.apply(i);
        return AggBuilder.inputFlatMap2(fn2, state);
    }

    public static <I, E, J, O, ACC extends Accumulator<J, E, O>, AGG extends ParallelAggregator<J, E, O, ACC>> AggInputFlatMap<I, E, J, O, ACC, AGG> inputFlatMap2(SerializableBiFunction<? super I, E, ? extends Iterator<? extends J>> inputTransform, AGG state) {
        return new AggInputFlatMap(state, inputTransform);
    }

    public static <I, E, O, P, ACC extends Accumulator<I, E, O>, AGG extends ParallelAggregator<I, E, O, ACC>> AggOutputTransform<I, E, O, P, ACC, AGG> outputTransform(AGG state, SerializableFunction<? super O, ? extends P> outputTransform) {
        return new AggOutputTransform(state, outputTransform);
    }

    public static <T, E> ParallelAggregator<T, E, Set<T>, Accumulator<T, E, Set<T>>> hashSetSupplier() {
        return AggBuilder.collectionSupplier(HashSet::new);
    }

    public static <T, E> ParallelAggregator<T, E, List<T>, Accumulator<T, E, List<T>>> arrayListSupplier() {
        return AggBuilder.collectionSupplier(ArrayList::new);
    }

    public static <T, E> ParallelAggregator<T, E, Set<T>, Accumulator<T, E, Set<T>>> setSupplier(SerializableSupplier<? extends Set<T>> setSupplier) {
        return AggBuilder.collectionSupplier(setSupplier);
    }

    public static <K, V, E> ParallelAggregator<Map.Entry<K, V>, E, SetOverMap<K, V>, Accumulator<Map.Entry<K, V>, E, SetOverMap<K, V>>> mapSupplier(SerializableSupplier<? extends Map<K, V>> mapSupplier) {
        return AggBuilder.naturalAccumulator((SerializableSupplier & Serializable)() -> new AccCollection(new SetOverMap((Map)mapSupplier.get())));
    }

    public static <T, E, C extends Collection<T>> ParallelAggregator<T, E, C, Accumulator<T, E, C>> collectionSupplier(SerializableSupplier<? extends C> colSupplier) {
        return AggBuilder.naturalAccumulator((SerializableSupplier & Serializable)() -> new AccCollection((Collection)colSupplier.get()));
    }

    public static <T, E, C extends Collection<T>> ParallelAggregator<T, E, C, Accumulator<T, E, C>> naturalAccumulator(SerializableSupplier<? extends Accumulator<T, E, C>> accSupplier) {
        return new AggNatural(accSupplier);
    }

    public static <I, E> ParallelAggregator<I, E, Long, Accumulator<I, E, Long>> counting() {
        return new AggCounting();
    }

    public static <I, E, O1, O2> ParallelAggregator<I, E, Map.Entry<O1, O2>, ?> inputBroadcast(ParallelAggregator<I, E, O1, ?> agg1, ParallelAggregator<I, E, O2, ?> agg2) {
        return new AggInputBroadcast(agg1, agg2);
    }

    public static <I, E, K, O> AggInputBroadcastMap<I, E, K, O> inputBroadcastMap(Map<K, ParallelAggregator<I, E, O, ?>> subAggMap) {
        return new AggInputBroadcastMap<I, E, K, O>(subAggMap);
    }

    public static <I, E> ParallelAggregator<I, E, I, Accumulator<I, E, I>> fold(SerializableSupplier<I> zeroElementSupplier, SerializableBinaryOperator<I> plusOperator) {
        return new AggReduce(zeroElementSupplier, plusOperator);
    }

    public static <T, E, R, A> AggFromCollector<T, E, R, A> fromCollector(SerializableSupplier<A> supplier, SerializableBiConsumer<A, T> accumulator, SerializableBinaryOperator<A> combiner, SerializableFunction<A, R> finisher) {
        return AggBuilder.fromCollector(supplier, accumulator, combiner, finisher, Collections.emptySet());
    }

    public static <T, E, R, A> AggFromCollector<T, E, R, A> fromCollector(SerializableSupplier<A> supplier, SerializableBiConsumer<A, T> accumulator, SerializableBinaryOperator<A> combiner, SerializableFunction<A, R> finisher, Set<Collector.Characteristics> characteristics) {
        SerializableCollectorImpl<T, A, R> collector = SerializableCollectorImpl.create(supplier, accumulator, combiner, finisher, characteristics);
        return AggBuilder.fromCollector(collector);
    }

    public static <T, E, A, R> AggFromCollector<T, E, R, A> fromCollector(SerializableCollector<T, A, R> collector) {
        return new AggFromCollector(collector);
    }

    public static <E> ParallelAggregator<Long, E, Long, Accumulator<Long, E, Long>> maxLong() {
        return AggBuilder.fold((SerializableSupplier & Serializable)() -> 0L, Math::max);
    }

    public static <E> ParallelAggregator<Integer, E, Integer, Accumulator<Integer, E, Integer>> maxInteger() {
        return AggBuilder.fold((SerializableSupplier & Serializable)() -> 0, Math::max);
    }

    public static <T, E> AggFromCollector<T, E, SerializableIntSummaryStatistics, SerializableIntSummaryStatistics> summarizingInt(SerializableToIntFunction<T> mapper) {
        return AggBuilder.fromCollector(SerializableIntSummaryStatistics::new, (SerializableBiConsumer & Serializable)(r, t) -> r.accept(mapper.applyAsInt(t)), (SerializableBinaryOperator & Serializable)(l, r) -> {
            l.combine((IntSummaryStatistics)r);
            return l;
        }, (SerializableFunction & Serializable)x -> x, CH_ID);
    }

    public static <T, E> AggFromCollector<T, E, SerializableLongSummaryStatistics, SerializableLongSummaryStatistics> summarizingLong(SerializableToLongFunction<T> mapper) {
        return AggBuilder.fromCollector(SerializableLongSummaryStatistics::new, (SerializableBiConsumer & Serializable)(r, t) -> r.accept(mapper.applyAsLong(t)), (SerializableBinaryOperator & Serializable)(l, r) -> {
            l.combine((LongSummaryStatistics)r);
            return l;
        }, (SerializableFunction & Serializable)x -> x, CH_ID);
    }

    public static <T, E> AggFromCollector<T, E, SerializableDoubleSummaryStatistics, SerializableDoubleSummaryStatistics> summarizingDouble(SerializableToDoubleFunction<T> mapper) {
        return AggBuilder.fromCollector(SerializableDoubleSummaryStatistics::new, (SerializableBiConsumer & Serializable)(r, t) -> r.accept(mapper.applyAsDouble(t)), (SerializableBinaryOperator & Serializable)(l, r) -> {
            l.combine((DoubleSummaryStatistics)r);
            return l;
        }, (SerializableFunction & Serializable)x -> x, CH_ID);
    }
}

