/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.core;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import org.aksw.commons.collector.core.CollectorFromParallelAggregator;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.ParallelAggregator;

public class ParallelAggregators {
    public static <T, E, V, C extends Collection<V>> Accumulator<T, E, C> combineAccumulators(Accumulator<T, E, C> needle, Accumulator<T, E, C> haystack, UnaryOperator<Accumulator<T, E, C>> accumulatorCloner, Function<? super V, ? extends T> valueToItem, E env) {
        if (((Collection)needle.getValue()).size() > ((Collection)haystack.getValue()).size()) {
            Accumulator<T, E, C> tmp = needle;
            needle = haystack;
            haystack = tmp;
        }
        Accumulator result = (Accumulator)accumulatorCloner.apply(haystack);
        for (Object value : (Collection)needle.getValue()) {
            T reductionItem = valueToItem.apply(value);
            result.accumulate(reductionItem, env);
        }
        return result;
    }

    public static <I, E, O, ACC extends Accumulator<I, E, O>> Collector<I, ?, O> createCollector(ParallelAggregator<I, E, O, ACC> agg, E env) {
        return new CollectorFromParallelAggregator<I, E, O, ACC>(agg, env);
    }
}

