/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.core;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.ParallelAggregator;
import org.aksw.commons.lambda.serializable.SerializableBiFunction;

public class AggLcaMap<T, E>
implements ParallelAggregator<T, E, Map<T, T>, Accumulator<T, E, Map<T, T>>>,
Serializable {
    private static final long serialVersionUID = 0L;
    protected BiFunction<? super T, ? super T, ? extends T> lcaFinder;

    public AggLcaMap(BiFunction<? super T, ? super T, ? extends T> lcaFinder) {
        this.lcaFinder = lcaFinder;
    }

    @Override
    public Accumulator<T, E, Map<T, T>> createAccumulator() {
        return new AccLcaMap(this.lcaFinder);
    }

    @Override
    public Accumulator<T, E, Map<T, T>> combine(Accumulator<T, E, Map<T, T>> a, Accumulator<T, E, Map<T, T>> b) {
        if (a.getValue().keySet().size() > b.getValue().keySet().size()) {
            Accumulator<T, Object, Map<T, T>> tmp = a;
            a = b;
            b = tmp;
        }
        Map<T, T> bm = b.getValue();
        for (T item : bm.keySet()) {
            a.accumulate(item, null);
        }
        return a;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lcaFinder == null ? 0 : this.lcaFinder.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggLcaMap other = (AggLcaMap)obj;
        return !(this.lcaFinder == null ? other.lcaFinder != null : !this.lcaFinder.equals(other.lcaFinder));
    }

    public static <T, E> AggLcaMap<T, E> create(SerializableBiFunction<? super T, ? super T, ? extends T> lcaFinder) {
        return new AggLcaMap<T, E>(lcaFinder);
    }

    public static class AccLcaMap<T, E>
    implements Accumulator<T, E, Map<T, T>>,
    Serializable {
        private static final long serialVersionUID = 0L;
        protected BiFunction<? super T, ? super T, ? extends T> lcaFinder;
        protected Map<T, T> childToAncestor = new LinkedHashMap<T, T>();

        public AccLcaMap(BiFunction<? super T, ? super T, ? extends T> lcaFinder) {
            this.lcaFinder = lcaFinder;
        }

        @Override
        public void accumulate(T input, E env) {
            T target = input;
            for (Map.Entry<T, T> e : this.childToAncestor.entrySet()) {
                Object currentRemap = e.getValue();
                Object lca = this.lcaFinder.apply(currentRemap, input);
                if (lca == null) continue;
                if (!lca.equals(currentRemap)) {
                    target = lca;
                    this.childToAncestor.entrySet().forEach(f -> {
                        if (f.getValue().equals(currentRemap)) {
                            f.setValue(lca);
                        }
                    });
                    continue;
                }
                target = currentRemap;
                break;
            }
            this.childToAncestor.put(input, target);
        }

        @Override
        public Map<T, T> getValue() {
            return this.childToAncestor;
        }

        public static <T, E> AccLcaMap<T, E> create(SerializableBiFunction<? super T, ? super T, ? extends T> lcaFinder) {
            return new AccLcaMap<T, E>(lcaFinder);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.childToAncestor == null ? 0 : this.childToAncestor.hashCode());
            result = 31 * result + (this.lcaFinder == null ? 0 : this.lcaFinder.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccLcaMap other = (AccLcaMap)obj;
            if (this.childToAncestor == null ? other.childToAncestor != null : !this.childToAncestor.equals(other.childToAncestor)) {
                return false;
            }
            return !(this.lcaFinder == null ? other.lcaFinder != null : !this.lcaFinder.equals(other.lcaFinder));
        }
    }
}

