/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.collector.core.AccWrapper;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.ParallelAggregator;

public class AggInputSplit<I, E, K, J, O, SUBACC extends Accumulator<J, E, O>, SUBAGG extends ParallelAggregator<J, E, O, SUBACC>>
implements ParallelAggregator<I, E, Map<K, O>, AccInputSplit<I, E, K, J, O, SUBACC>>,
Serializable {
    private static final long serialVersionUID = 0L;
    protected Set<K> fixedKeys;
    protected boolean considerNewKeys;
    protected Function<? super I, ? extends Set<? extends K>> keyMapper;
    protected BiFunction<? super I, ? super K, ? extends J> valueMapper;
    protected SUBAGG subAgg;

    public AggInputSplit(SUBAGG subAgg, Function<? super I, ? extends Set<? extends K>> keyMapper, BiFunction<? super I, ? super K, ? extends J> valueMapper) {
        this(subAgg, Collections.emptySet(), true, keyMapper, valueMapper);
    }

    public AggInputSplit(SUBAGG subAgg, Set<K> fixedKeys, boolean considerNewKeys, Function<? super I, ? extends Set<? extends K>> keyMapper, BiFunction<? super I, ? super K, ? extends J> valueMapper) {
        this.fixedKeys = fixedKeys;
        this.considerNewKeys = considerNewKeys;
        this.subAgg = subAgg;
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
    }

    @Override
    public AccInputSplit<I, E, K, J, O, SUBACC> createAccumulator() {
        LinkedHashMap keyToSubAcc = new LinkedHashMap();
        for (K key : this.fixedKeys) {
            keyToSubAcc.put(key, this.subAgg.createAccumulator());
        }
        return new AccSplitInputImpl(keyToSubAcc);
    }

    @Override
    public AccInputSplit<I, E, K, J, O, SUBACC> combine(AccInputSplit<I, E, K, J, O, SUBACC> a, AccInputSplit<I, E, K, J, O, SUBACC> b) {
        Map accA = (Map)a.getSubAcc();
        Map accB = (Map)b.getSubAcc();
        LinkedHashMap newMap = new LinkedHashMap();
        HashSet allKeys = new HashSet();
        allKeys.addAll(accA.keySet());
        allKeys.addAll(accB.keySet());
        for (Object key : allKeys) {
            Accumulator combined;
            Accumulator subAccA = (Accumulator)accA.get(key);
            Accumulator subAccB = (Accumulator)accB.get(key);
            if (subAccA != null) {
                combined = subAccB != null ? this.subAgg.combine((Accumulator)subAccA, (Accumulator)subAccB) : subAccA;
            } else if (subAccB != null) {
                combined = subAccB;
            } else {
                throw new RuntimeException("Combination of two null accumulators - should never happen");
            }
            newMap.put(key, combined);
        }
        return new AccSplitInputImpl(newMap);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.considerNewKeys ? 1231 : 1237);
        result = 31 * result + (this.fixedKeys == null ? 0 : this.fixedKeys.hashCode());
        result = 31 * result + (this.keyMapper == null ? 0 : this.keyMapper.hashCode());
        result = 31 * result + (this.subAgg == null ? 0 : this.subAgg.hashCode());
        result = 31 * result + (this.valueMapper == null ? 0 : this.valueMapper.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggInputSplit other = (AggInputSplit)obj;
        if (this.considerNewKeys != other.considerNewKeys) {
            return false;
        }
        if (this.fixedKeys == null ? other.fixedKeys != null : !this.fixedKeys.equals(other.fixedKeys)) {
            return false;
        }
        if (this.keyMapper == null ? other.keyMapper != null : !this.keyMapper.equals(other.keyMapper)) {
            return false;
        }
        if (this.subAgg == null ? other.subAgg != null : !this.subAgg.equals(other.subAgg)) {
            return false;
        }
        return !(this.valueMapper == null ? other.valueMapper != null : !this.valueMapper.equals(other.valueMapper));
    }

    public class AccSplitInputImpl
    implements AccInputSplit<I, E, K, J, O, SUBACC>,
    Serializable {
        private static final long serialVersionUID = 0L;
        protected Map<K, SUBACC> keyToSubAcc;

        public AccSplitInputImpl(Map<K, SUBACC> keyToSubAcc) {
            this.keyToSubAcc = keyToSubAcc;
        }

        @Override
        public void accumulate(I input, E env) {
            Set keys = AggInputSplit.this.keyMapper.apply(input);
            for (Object key : keys) {
                if (!AggInputSplit.this.considerNewKeys && !AggInputSplit.this.fixedKeys.contains(key)) continue;
                Accumulator subAcc = this.keyToSubAcc.computeIfAbsent(key, k -> AggInputSplit.this.subAgg.createAccumulator());
                Object newInput = AggInputSplit.this.valueMapper.apply(input, key);
                subAcc.accumulate(newInput, env);
            }
        }

        @Override
        public Map<K, O> getValue() {
            Map result = this.keyToSubAcc.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Accumulator)e.getValue()).getValue(), (u, v) -> u, LinkedHashMap::new));
            return result;
        }

        @Override
        public Map<K, SUBACC> getSubAcc() {
            return this.keyToSubAcc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + (this.keyToSubAcc == null ? 0 : this.keyToSubAcc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccSplitInputImpl other = (AccSplitInputImpl)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return !(this.keyToSubAcc == null ? other.keyToSubAcc != null : !this.keyToSubAcc.equals(other.keyToSubAcc));
        }

        private AggInputSplit<?, ?, ?, ?, ?, ?, ?> getEnclosingInstance() {
            return AggInputSplit.this;
        }
    }

    public static interface AccInputSplit<I, E, K, J, O, SUBACC extends Accumulator<J, E, O>>
    extends AccWrapper<I, E, Map<K, O>, Map<K, SUBACC>> {
    }
}

