/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.core;

import java.io.Serializable;
import java.util.Map;
import java.util.stream.Collectors;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.ParallelAggregator;

public class AggInputBroadcastMap<I, E, K, O>
implements ParallelAggregator<I, E, Map<K, O>, AccInputBroadcastMap<I, E, K, O>>,
Serializable {
    private static final long serialVersionUID = 0L;
    protected Map<K, ParallelAggregator<I, E, O, ?>> subAggMap;

    public AggInputBroadcastMap(Map<K, ParallelAggregator<I, E, O, ?>> subAggMap) {
        this.subAggMap = subAggMap;
    }

    @Override
    public AccInputBroadcastMap<I, E, K, O> createAccumulator() {
        Map<Object, Accumulator> subAccMap = this.subAggMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ParallelAggregator)e.getValue()).createAccumulator()));
        return new AccInputBroadcastMapImpl(subAccMap);
    }

    @Override
    public AccInputBroadcastMap<I, E, K, O> combine(AccInputBroadcastMap<I, E, K, O> a, AccInputBroadcastMap<I, E, K, O> b) {
        Map am = a.getSubAccMap();
        Map bm = b.getSubAccMap();
        Map<Object, Accumulator> newMap = this.subAggMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Object key = e.getKey();
            ParallelAggregator subAgg = (ParallelAggregator)e.getValue();
            Accumulator as = (Accumulator)am.get(key);
            Accumulator bs = (Accumulator)bm.get(key);
            Object r = subAgg.combineRaw(as, bs);
            return r;
        }));
        return new AccInputBroadcastMapImpl(newMap);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.subAggMap == null ? 0 : this.subAggMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggInputBroadcastMap other = (AggInputBroadcastMap)obj;
        return !(this.subAggMap == null ? other.subAggMap != null : !this.subAggMap.equals(other.subAggMap));
    }

    public class AccInputBroadcastMapImpl
    implements AccInputBroadcastMap<I, E, K, O>,
    Serializable {
        private static final long serialVersionUID = 0L;
        protected Map<K, Accumulator<I, E, O>> keyToSubAcc;

        public AccInputBroadcastMapImpl(Map<K, Accumulator<I, E, O>> keyToSubAcc) {
            this.keyToSubAcc = keyToSubAcc;
        }

        @Override
        public void accumulate(I input, E env) {
            for (Map.Entry e : AggInputBroadcastMap.this.subAggMap.entrySet()) {
                Accumulator acc = this.keyToSubAcc.computeIfAbsent(e.getKey(), k -> ((ParallelAggregator)e.getValue()).createAccumulator());
                acc.accumulate(input, env);
            }
        }

        @Override
        public Map<K, O> getValue() {
            Map<Object, Object> result = this.keyToSubAcc.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Accumulator)e.getValue()).getValue()));
            return result;
        }

        @Override
        public Map<K, Accumulator<I, E, O>> getSubAccMap() {
            return this.keyToSubAcc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + (this.keyToSubAcc == null ? 0 : this.keyToSubAcc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccInputBroadcastMapImpl other = (AccInputBroadcastMapImpl)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return !(this.keyToSubAcc == null ? other.keyToSubAcc != null : !this.keyToSubAcc.equals(other.keyToSubAcc));
        }

        private AggInputBroadcastMap<?, ?, ?, ?> getEnclosingInstance() {
            return AggInputBroadcastMap.this;
        }
    }

    public static interface AccInputBroadcastMap<I, E, K, O>
    extends Accumulator<I, E, Map<K, O>> {
        public Map<K, Accumulator<I, E, O>> getSubAccMap();
    }
}

