/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.core;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.aksw.commons.collector.core.AccWrapper;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.ParallelAggregator;

public class AggErrorHandler<I, E, O, SUBACC extends Accumulator<I, E, O>, SUBAGG extends ParallelAggregator<I, E, O, SUBACC>>
implements ParallelAggregator<I, E, O, AccError<I, E, O, SUBACC>>,
Serializable {
    private static final long serialVersionUID = 0L;
    protected SUBAGG subAgg;
    protected Function<AccError<I, E, O, SUBACC>, O> errorValueExtractor;
    protected Consumer<? super Throwable> errorCallback;
    protected boolean subAccDespiteError;

    public AggErrorHandler(SUBAGG subAgg, boolean subAccDespiteError, Consumer<? super Throwable> errorCallback, Function<AccError<I, E, O, SUBACC>, O> errorValueExtractor) {
        this.subAgg = subAgg;
        this.subAccDespiteError = subAccDespiteError;
        this.errorCallback = errorCallback;
        this.errorValueExtractor = errorValueExtractor;
    }

    @Override
    public AccError<I, E, O, SUBACC> createAccumulator() {
        Object subAcc = this.subAgg.createAccumulator();
        return new AccErrorImpl(this, subAcc, 0L);
    }

    @Override
    public AccError<I, E, O, SUBACC> combine(AccError<I, E, O, SUBACC> a, AccError<I, E, O, SUBACC> b) {
        Accumulator accA = (Accumulator)a.getSubAcc();
        Accumulator accB = (Accumulator)b.getSubAcc();
        long totalErrorCount = a.getErrorCount() + b.getErrorCount();
        Accumulator subAcc = totalErrorCount == 0L || this.subAccDespiteError ? this.subAgg.combine((Accumulator)accA, (Accumulator)accB) : null;
        return new AccErrorImpl(this, subAcc, totalErrorCount);
    }

    public int hashCode() {
        return Objects.hash(this.errorCallback, this.errorValueExtractor, this.subAccDespiteError, this.subAgg);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggErrorHandler other = (AggErrorHandler)obj;
        return Objects.equals(this.errorCallback, other.errorCallback) && Objects.equals(this.errorValueExtractor, other.errorValueExtractor) && this.subAccDespiteError == other.subAccDespiteError && Objects.equals(this.subAgg, other.subAgg);
    }

    public class AccErrorImpl
    implements AccError<I, E, O, SUBACC>,
    Serializable {
        private static final long serialVersionUID = 0L;
        protected SUBACC subAcc;
        protected long errorCount;
        final /* synthetic */ AggErrorHandler this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public AccErrorImpl(SUBACC errorCount, long l) {
            void subAcc;
            this.this$0 = (AggErrorHandler)this$0;
            this.subAcc = subAcc;
            this.errorCount = (long)errorCount;
        }

        @Override
        public void accumulate(I input, E env) {
            block3: {
                try {
                    if (this.errorCount == 0L || this.this$0.subAccDespiteError) {
                        this.subAcc.accumulate(input, env);
                    }
                }
                catch (Exception e) {
                    ++this.errorCount;
                    if (this.this$0.errorCallback == null) break block3;
                    this.this$0.errorCallback.accept(e);
                }
            }
        }

        @Override
        public SUBACC getSubAcc() {
            return this.subAcc;
        }

        @Override
        public long getErrorCount() {
            return this.errorCount;
        }

        @Override
        public O getValue() {
            Object result = this.errorCount == 0L ? this.subAcc.getValue() : (this.this$0.errorValueExtractor == null ? null : this.this$0.errorValueExtractor.apply(this));
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + Objects.hash(this.errorCount, this.subAcc);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccErrorImpl other = (AccErrorImpl)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return this.errorCount == other.errorCount && Objects.equals(this.subAcc, other.subAcc);
        }

        private AggErrorHandler<?, ?, ?, ?, ?> getEnclosingInstance() {
            return this.this$0;
        }
    }

    public static interface AccError<I, E, O, SUBACC extends Accumulator<I, E, O>>
    extends AccWrapper<I, E, O, SUBACC> {
        public long getErrorCount();
    }
}

