/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.utils;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Streams;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.collections.IteratorUtils;
import org.aksw.commons.lambda.throwing.ThrowingBiConsumer;
import org.aksw.commons.lambda.throwing.ThrowingFunction;

public class StreamUtils {
    public static <T> Iterable<T> iterable(Stream<T> stream) {
        Iterable result = () -> stream.iterator();
        return result;
    }

    public static <T> T expectOneItem(Stream<T> stream) {
        try {
            Object t = IteratorUtils.expectOneItem(stream.iterator());
            return t;
        }
        finally {
            stream.close();
        }
    }

    public static <T> T expectZeroOrOneItems(Stream<T> stream) {
        try {
            Object t = IteratorUtils.expectZeroOrOneItems(stream.iterator());
            return t;
        }
        finally {
            stream.close();
        }
    }

    public static <T> Stream<Map.Entry<T, T>> streamToPairs(Stream<T> stream) {
        final Iterator baseIt = stream.iterator();
        AbstractIterator it = new AbstractIterator<Map.Entry<T, T>>(){
            protected T priorValue = null;

            protected Map.Entry<T, T> computeNext() {
                AbstractMap.SimpleEntry r;
                if (baseIt.hasNext()) {
                    Object item = baseIt.next();
                    r = new AbstractMap.SimpleEntry(this.priorValue, item);
                    this.priorValue = item;
                } else {
                    r = (AbstractMap.SimpleEntry)this.endOfData();
                }
                return r;
            }
        };
        Stream result = Streams.stream((Iterator)it);
        result.onClose(() -> stream.close());
        return result;
    }

    public static <T> Stream<List<T>> mapToBatch(Stream<T> stream, final int batchSize) {
        final Iterator baseIt = stream.iterator();
        AbstractIterator it = new AbstractIterator<List<T>>(){

            protected List<T> computeNext() {
                ArrayList items = new ArrayList(batchSize);
                for (int i = 0; baseIt.hasNext() && i < batchSize; ++i) {
                    Object item = baseIt.next();
                    items.add(item);
                }
                ArrayList r = items.isEmpty() ? (List)this.endOfData() : items;
                return r;
            }
        };
        Stream result = Streams.stream((Iterator)it);
        result.onClose(() -> stream.close());
        return result;
    }

    public static <T> Stream<T> appendAction(Stream<? extends T> stream, Runnable runnable) {
        Stream<Object> result = Stream.concat(stream, Stream.of(null).filter(x -> {
            runnable.run();
            return false;
        }));
        return result;
    }

    public static <S, X> Stream<X> stream(BiConsumer<S, Consumer<X>> fn, S baseSolution) {
        ArrayList result = new ArrayList();
        fn.accept(baseSolution, item -> result.add(item));
        return result.stream();
    }

    public static <T, R, E> Stream<T> fromEnumerableResource(Callable<R> resourceSupplier, ThrowingFunction<? super R, E> toEnumerable, ThrowingFunction<? super E, T> nextRecord, BiPredicate<T, ? super E> hasEnded, ThrowingBiConsumer<? super R, ? super E> closer) {
        IteratorOverEnumerable<T, ? super R, ? super E> it = new IteratorOverEnumerable<T, R, E>(resourceSupplier, toEnumerable, nextRecord, hasEnded, closer);
        Stream result = (Stream)Streams.stream(it).onClose(it::close);
        return result;
    }

    public static <T> Stream<T> viaList(Stream<T> in, Consumer<List<T>> consumer) {
        List list;
        try (Stream tmp = in;){
            list = tmp.collect(Collectors.toList());
        }
        if (consumer != null) {
            consumer.accept(list);
        }
        return list.stream();
    }

    public static <T> Stream<T> println(Stream<T> in) {
        return StreamUtils.viaList(in, System.out::println);
    }

    public static class IteratorOverEnumerable<T, R, E>
    extends AbstractIterator<T>
    implements AutoCloseable {
        protected Callable<R> resourceSupplier;
        protected ThrowingFunction<? super R, E> toEnumerable;
        protected ThrowingFunction<? super E, T> nextRecord;
        protected BiPredicate<T, ? super E> hasEnded;
        protected ThrowingBiConsumer<? super R, ? super E> closer;
        protected boolean isClosed = false;
        protected R resource;
        protected E enumerable;

        public IteratorOverEnumerable(Callable<R> resourceSupplier, ThrowingFunction<? super R, E> toEnumerable, ThrowingFunction<? super E, T> nextRecord, BiPredicate<T, ? super E> hasEnded, ThrowingBiConsumer<? super R, ? super E> closer) {
            this.resourceSupplier = resourceSupplier;
            this.toEnumerable = toEnumerable;
            this.nextRecord = nextRecord;
            this.hasEnded = hasEnded;
            this.closer = closer;
        }

        protected T computeNext() {
            Object result;
            if (this.isClosed) {
                throw new IllegalStateException("already closed");
            }
            if (this.enumerable == null && this.resource == null) {
                try {
                    this.resource = this.resourceSupplier.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                Objects.requireNonNull(this.resource, "Resource supplier was expected to supply a resource but returned null.");
                try {
                    this.enumerable = this.toEnumerable.apply(this.resource);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                result = this.nextRecord.apply(this.enumerable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            boolean isDone = this.hasEnded.test(result, this.enumerable);
            if (isDone) {
                result = this.endOfData();
            }
            return (T)result;
        }

        @Override
        public void close() {
            this.isClosed = true;
            try {
                if (this.resource != null) {
                    this.closer.accept(this.resource, this.enumerable);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

