/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.trees;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.aksw.commons.collections.trees.Tree;
import org.aksw.commons.collections.trees.TreeBase;
import org.aksw.commons.collections.trees.TreeUtils;

public class TreeImpl<T>
extends TreeBase<T> {
    protected T root;
    protected Function<T, List<T>> parentToChildren;
    protected Function<T, T> childToParent;
    protected BiFunction<T, List<T>, T> copyNode;

    @Override
    public Tree<T> createNew(T root) {
        TreeImpl<T> result = TreeImpl.create(root, this.parentToChildren);
        return result;
    }

    public TreeImpl(T root, Function<T, List<T>> parentToChildren, Function<T, T> childToParent, BiFunction<T, List<T>, T> copyNode) {
        this.root = root;
        this.parentToChildren = parentToChildren;
        this.childToParent = childToParent;
        this.copyNode = copyNode;
    }

    @Override
    public T getRoot() {
        return this.root;
    }

    @Override
    public List<T> getChildren(T node) {
        List result = node == null ? (this.root != null ? Collections.emptyList() : this.parentToChildren.apply(node)) : this.parentToChildren.apply(node);
        return result;
    }

    @Override
    public T getParent(T node) {
        T result = this.childToParent.apply(node);
        return result;
    }

    public static <T> TreeImpl<T> create(T root, Function<T, List<T>> parentToChildren) {
        Map childToParent = TreeUtils.parentMap(root, parentToChildren);
        TreeImpl<Object> result = new TreeImpl<Object>(root, parentToChildren, node -> childToParent.get(node), (a, b) -> {
            throw new UnsupportedOperationException();
        });
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.childToParent == null ? 0 : this.childToParent.hashCode());
        result = 31 * result + (this.parentToChildren == null ? 0 : this.parentToChildren.hashCode());
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeImpl other = (TreeImpl)obj;
        if (this.childToParent == null ? other.childToParent != null : !this.childToParent.equals(other.childToParent)) {
            return false;
        }
        if (this.parentToChildren == null ? other.parentToChildren != null : !this.parentToChildren.equals(other.parentToChildren)) {
            return false;
        }
        return !(this.root == null ? other.root != null : !this.root.equals(other.root));
    }

    public String toString() {
        return "TreeImpl [root=" + String.valueOf(this.root) + ", parentToChild=" + String.valueOf(this.parentToChildren) + ", childToParent=" + String.valueOf(this.childToParent) + "]";
    }

    @Override
    public T copy(T node, List<T> children) {
        T result = this.copyNode.apply(node, children);
        return result;
    }
}

