/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.selector;

import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.collections.selector.WeightedSelectorMutableBase;

public class WeightedSelectorMutable<T>
extends WeightedSelectorMutableBase<T> {
    @Override
    public WeightedSelectorMutable<T> clone() {
        return new WeightedSelectorMutable<T>(new ArrayList<Map.Entry<T, ? extends Number>>(this.entries));
    }

    public WeightedSelectorMutable() {
    }

    public WeightedSelectorMutable(List<Map.Entry<T, ? extends Number>> entries) {
        super(entries);
    }

    public static <T> WeightedSelectorMutable<T> create(Map<T, ? extends Number> map) {
        return WeightedSelectorMutable.create(map.entrySet(), Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T> WeightedSelectorMutable<T> create(Iterable<T> items, Function<? super T, ? extends Number> getWeight) {
        return WeightedSelectorMutable.create(items, Functions.identity(), getWeight);
    }

    public static <X, T> WeightedSelectorMutable<T> create(Iterable<X> items, Function<? super X, ? extends T> getEntity, Function<? super X, ? extends Number> getWeight) {
        Function<List, WeightedSelectorMutable> ctor = WeightedSelectorMutable::new;
        return WeightedSelectorMutable.configure(ctor, items, getEntity, getWeight);
    }

    public static <X, T, S> S configure(Function<List<Map.Entry<T, ? extends Number>>, S> ctor, Iterable<X> items, Function<? super X, ? extends T> getEntity, Function<? super X, ? extends Number> getWeight) {
        List es = Streams.stream(items).map(item -> Maps.immutableEntry(getEntity.apply((Object)item), (Object)((Number)getWeight.apply((Object)item)).doubleValue())).collect(Collectors.toCollection(ArrayList::new));
        return ctor.apply(es);
    }
}

