/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.multimaps;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.collections.MultiMaps;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;

public class MultimapUtils {
    public static <G, T> Multimap<G, T> groupBy(Iterable<T> items, Function<T, G> itemToGroupKey, Multimap<G, T> result) {
        for (T item : items) {
            G groupKey = itemToGroupKey.apply(item);
            result.put(groupKey, item);
        }
        return result;
    }

    public static <K, V> SetMultimap<K, V> newSetMultimap(boolean identityKeys, boolean identityValues) {
        AbstractMap keys = identityKeys ? Maps.newIdentityHashMap() : new HashMap();
        Supplier values = identityValues ? Sets::newIdentityHashSet : HashSet::new;
        return Multimaps.newSetMultimap((Map)keys, (Supplier)values);
    }

    public static <K, V> SetMultimap<K, V> newIdentitySetMultimap() {
        return Multimaps.newSetMultimap((Map)Maps.newIdentityHashMap(), Sets::newIdentityHashSet);
    }

    public static <K, V> ListMultimap<K, V> newIdentityListMultimap() {
        return Multimaps.newListMultimap((Map)Maps.newIdentityHashMap(), ArrayList::new);
    }

    public static <K, V> Set<V> getAll(Multimap<K, V> multiMap, Collection<K> keys) {
        Set result = keys.stream().flatMap(k -> multiMap.get(k).stream()).collect(Collectors.toSet());
        return result;
    }

    public static <T> Set<T> transitiveGetBoth(IBiSetMultimap<T, T> map, Object key) {
        Set result = MultiMaps.transitiveGet(map.asMap(), key);
        result.addAll(MultiMaps.transitiveGet(map.getInverse().asMap(), key));
        return result;
    }

    public static <K, V> Map<K, V> toMap(Map<K, ? extends Collection<V>> mm) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, Collection<V>> entry : mm.entrySet()) {
            K k = entry.getKey();
            Collection<V> vs = entry.getValue();
            if (vs.isEmpty()) continue;
            if (vs.size() > 1) {
                throw new RuntimeException("Ambigous mapping for " + String.valueOf(k) + ": " + String.valueOf(vs));
            }
            V v = vs.iterator().next();
            result.put(k, v);
        }
        return result;
    }
}

