/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.maps;

import com.google.common.base.Converter;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.aksw.commons.collections.ConvertingCollection;
import org.aksw.commons.collections.maps.EntryConverterByKey;
import org.aksw.commons.collections.sets.SetFromCollection;

public class MapFromValueConverter<K, U, V>
extends AbstractMap<K, V> {
    protected Map<K, U> map;
    protected Converter<U, V> converter;

    public MapFromValueConverter(Map<K, U> map, Converter<U, V> converter) {
        this.map = map;
        this.converter = converter;
    }

    @Override
    public V get(Object key) {
        V result = Optional.ofNullable(this.map.get(key)).map(arg_0 -> this.converter.convert(arg_0)).orElse(null);
        return result;
    }

    @Override
    public boolean containsKey(Object key) {
        boolean result = this.map.containsKey(key);
        return result;
    }

    @Override
    public V put(K key, V value) {
        Object val = this.converter.reverse().convert(value);
        this.map.put(key, val);
        return value;
    }

    @Override
    public boolean containsValue(Object value) {
        Object val = this.converter.reverse().convert(value);
        boolean result = this.map.containsValue(val);
        return result;
    }

    @Override
    public Collection<V> values() {
        return new ConvertingCollection<V, U, Collection<U>>(this.map.values(), this.converter);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SetFromCollection<Map.Entry<K, V>>(new ConvertingCollection(this.map.entrySet(), EntryConverterByKey.converterByValue(this.converter)));
    }
}

