/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.lists;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.lists.LinkedListIterator;
import org.aksw.commons.collections.lists.LinkedListNodeIterator;

public class LinkedListNode<T>
implements Iterable<T> {
    public T data;
    public LinkedListNode<T> predecessor;
    public LinkedListNode<T> successor;

    public void append(LinkedListNode<T> node) {
        this.successor = node;
        node.predecessor = this;
    }

    public void unlink() {
        this.predecessor.successor = this.successor;
        this.successor.predecessor = this.predecessor;
    }

    public void relink() {
        this.successor.predecessor = this;
        this.predecessor.successor = this;
    }

    public boolean isHead() {
        boolean result = this.predecessor == null;
        return result;
    }

    public boolean isTail() {
        boolean result = this.successor == null;
        return result;
    }

    public boolean isFirst() {
        boolean result = this.predecessor.isHead();
        return result;
    }

    public boolean isLast() {
        boolean result = this.successor.isTail();
        return result;
    }

    public List<T> toList() {
        ArrayList<T> result = new ArrayList<T>();
        LinkedListNode<T> curr = this;
        while (!curr.isTail()) {
            result.add(curr.data);
            curr = curr.successor;
        }
        return result;
    }

    public String toString() {
        String result = Iterables.toString((Iterable)this);
        return result;
    }

    public static <S> LinkedListNode<S> create(Iterable<? extends S> it) {
        LinkedListNode head = new LinkedListNode();
        head.data = null;
        LinkedListNode curr = head;
        for (S item : it) {
            LinkedListNode next = new LinkedListNode();
            next.data = item;
            curr.append(next);
            curr = next;
        }
        LinkedListNode tail = new LinkedListNode();
        curr.append(tail);
        return head;
    }

    @Override
    public Iterator<T> iterator() {
        LinkedListIterator<T> result = this.isHead() ? new LinkedListIterator<T>(this.successor) : new LinkedListIterator(this);
        return result;
    }

    public int size() {
        int result = Iterators.size(this.iterator());
        return result;
    }

    public Iterator<LinkedListNode<T>> nodeIterator() {
        LinkedListNodeIterator<T> result = this.isHead() ? new LinkedListNodeIterator<T>(this.successor) : new LinkedListNodeIterator(this);
        return result;
    }
}

