/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.lists;

import java.util.AbstractList;
import java.util.Iterator;
import org.aksw.commons.collections.lists.LinkedListNode;

public class LinkedList<T>
extends AbstractList<T> {
    protected LinkedListNode<T> first = new LinkedListNode();
    protected LinkedListNode<T> last = new LinkedListNode();
    protected int size;

    public LinkedList() {
        this.first.successor = this.last;
        this.last.predecessor = this.first;
    }

    public LinkedListNode<T> append(T item) {
        LinkedListNode result = new LinkedListNode();
        result.data = item;
        LinkedListNode prev = this.last.predecessor;
        prev.successor = result;
        result.predecessor = prev;
        result.successor = this.last;
        this.last.predecessor = result;
        return result;
    }

    @Override
    public boolean add(T item) {
        this.append(item);
        return true;
    }

    @Override
    public T get(int index) {
        LinkedListNode curr = this.first.successor;
        for (int i = 0; i < index; ++i) {
            curr = curr.successor;
        }
        Object result = curr.data;
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator<T> result = this.first.iterator();
        return result;
    }

    @Override
    public int size() {
        int result = 0;
        LinkedListNode curr = this.first.successor;
        while (curr != this.last) {
            curr = curr.successor;
            ++result;
        }
        return result;
    }
}

