/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.generator;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.aksw.commons.collections.generator.Converters;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.commons.collections.generator.GeneratorForwarding;
import org.aksw.commons.collections.generator.GeneratorFromFunction;
import org.aksw.commons.collections.generator.GeneratorLending;
import org.aksw.commons.collections.generator.GeneratorLendingFromConverter;

public class GeneratorLendingImpl<T>
extends GeneratorForwarding<T>
implements GeneratorLending<T> {
    protected Supplier<? extends Collection<T>> collectionSupplier;
    protected Collection<T> freeIds;
    protected T current;

    public GeneratorLendingImpl(Generator<T> delegate, Supplier<? extends Collection<T>> collectionSupplier) {
        this(delegate, collectionSupplier.get(), collectionSupplier);
    }

    public GeneratorLendingImpl(Generator<T> delegate, Collection<T> freeIds, Supplier<? extends Collection<T>> collectionSupplier) {
        super(delegate);
        this.freeIds = freeIds;
        this.collectionSupplier = collectionSupplier;
    }

    @Override
    public boolean giveBack(T item) {
        this.freeIds.add(item);
        return true;
    }

    @Override
    public T next() {
        Iterator<T> it = this.freeIds.iterator();
        if (it.hasNext()) {
            this.current = it.next();
            it.remove();
        } else {
            this.current = this.delegate.next();
        }
        return this.current;
    }

    @Override
    public T current() {
        return this.current;
    }

    @Override
    public GeneratorForwarding<T> clone() {
        Collection<T> copy = this.collectionSupplier.get();
        copy.addAll(this.freeIds);
        return new GeneratorLendingImpl(this.delegate.clone(), copy, this.collectionSupplier);
    }

    public static <T extends Comparable<T>> GeneratorLendingImpl<T> createSorted(Generator<T> delegate) {
        return new GeneratorLendingImpl<T>(delegate, TreeSet::new);
    }

    public static GeneratorLendingImpl<Integer> createInt() {
        return GeneratorLendingImpl.createInt(0);
    }

    public static GeneratorLendingImpl<Integer> createInt(int initialNext) {
        return new GeneratorLendingImpl<Integer>(GeneratorFromFunction.createInt(initialNext), TreeSet::new);
    }

    public static GeneratorLending<String> createPrefixedInt(String prefix, int offset) {
        return new GeneratorLendingFromConverter<String, Integer, GeneratorLendingImpl<Integer>>(GeneratorLendingImpl.createInt(offset), Converters.prefixIntToStr(prefix));
    }
}

