/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.generator;

import java.util.Collection;
import java.util.function.Predicate;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.commons.collections.generator.GeneratorForwarding;

public class GeneratorBlacklist<T>
extends GeneratorForwarding<T> {
    private Predicate<? super T> isBlacklisted;

    public GeneratorBlacklist(Generator<T> delegate, Predicate<? super T> isBlacklisted) {
        super(delegate);
        this.isBlacklisted = isBlacklisted;
    }

    @Override
    public GeneratorBlacklist<T> clone() {
        Generator clone = this.delegate.clone();
        GeneratorBlacklist<? super T> result = new GeneratorBlacklist<T>(clone, this.isBlacklisted);
        return result;
    }

    @Override
    public T next() {
        Object result;
        while (this.isBlacklisted.test(result = this.delegate.next())) {
        }
        return result;
    }

    @Override
    public T current() {
        Object result = this.delegate.current();
        return result;
    }

    public static <T> GeneratorBlacklist<T> create(Generator<T> generator, Predicate<? super T> isBlacklisted) {
        GeneratorBlacklist<? super T> result = new GeneratorBlacklist<T>(generator, isBlacklisted);
        return result;
    }

    public static <T> GeneratorBlacklist<T> create(Generator<T> generator, Collection<?> blacklist) {
        GeneratorBlacklist<Object> result = GeneratorBlacklist.create(generator, blacklist::contains);
        return result;
    }

    public static GeneratorBlacklist<String> create(String prefix, Collection<?> blacklist) {
        GeneratorBlacklist<String> result = GeneratorBlacklist.create(Generator.create(prefix), blacklist::contains);
        return result;
    }
}

