/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.generator;

import com.google.common.base.Converter;
import java.util.function.Function;

public class Converters {
    public static Converter<Integer, String> prefixIntToStr(String prefix) {
        return Converters.prefix(prefix, Integer::parseInt, x -> Integer.toString(x));
    }

    public static <T> Converter<T, String> prefix(final String prefix, final Function<String, T> parse, final Function<T, String> unparse) {
        final int n = prefix.length();
        return new Converter<T, String>(){

            protected String doForward(T a) {
                String str = (String)unparse.apply(a);
                return prefix + str;
            }

            protected T doBackward(String b) {
                Object result;
                if (b.startsWith(prefix)) {
                    String substr = b.substring(n, b.length());
                    result = parse.apply(substr);
                } else {
                    result = null;
                }
                return result;
            }
        };
    }
}

