/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.cache;

import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;

public class RemovalListenerMultiplexer<K, V>
implements RemovalListener<K, V> {
    protected Set<RemovalListener<K, V>> clients = Sets.newIdentityHashSet();

    public Set<RemovalListener<K, V>> getClients() {
        return this.clients;
    }

    public void onRemoval(RemovalNotification<K, V> notification) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (RemovalListener<K, V> client : this.clients) {
            try {
                client.onRemoval(notification);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            Throwable t = (Throwable)exceptions.iterator().next();
            throw new RuntimeException(t);
        }
    }
}

