/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.Stream;
import org.aksw.commons.collections.IteratorUtils;

public class IterableUtils {
    @Deprecated
    public static <T> T expectOneItem(Iterable<T> iterable) {
        return IteratorUtils.expectOneItem(iterable.iterator());
    }

    @Deprecated
    public static <T> T expectZeroOrOneItems(Iterable<T> iterable) {
        return IteratorUtils.expectZeroOrOneItems(iterable.iterator());
    }

    public static <T> Comparator<? super Iterable<? extends T>> newComparatorForIterablesOfEqualLength(Comparator<? super T> itemComparator) {
        return (a, b) -> IterableUtils.compareIterablesOfEqualLength(a, b, itemComparator);
    }

    public static <T> int compareIterablesOfEqualLength(Iterable<? extends T> a, Iterable<? extends T> b, Comparator<? super T> itemComparator) {
        int result = Streams.zip((Stream)Streams.stream(a), (Stream)Streams.stream(b), (x, y) -> itemComparator.compare(x, y)).mapToInt(x -> x).filter(x -> x != 0).findFirst().orElse(0);
        return result;
    }

    public static <T> int compareByLengthThenItems(Iterable<? extends T> a, Iterable<? extends T> b, Comparator<? super T> itemComparator) {
        int result = ComparisonChain.start().compare(Iterables.size(a), Iterables.size(b)).compare(a, b, IterableUtils.newComparatorForIterablesOfEqualLength(itemComparator)).result();
        return result;
    }

    public static boolean equalsByReference(Iterable<?> a, Iterable<?> b) {
        int val = IterableUtils.compare(a, b, (x, y) -> x == y ? 0 : -1);
        return val == 0;
    }

    public static <X> int compare(Iterable<? extends X> a, Iterable<? extends X> b, Comparator<X> comparator) {
        if (a instanceof Collection) {
            Collection bb;
            int d;
            Collection aa = (Collection)a;
            if (b instanceof Collection && (d = (bb = (Collection)b).size() - aa.size()) != 0) {
                return d;
            }
        }
        Iterator<? extends X> it1 = a.iterator();
        Iterator<? extends X> it2 = b.iterator();
        int result = IteratorUtils.compare(it1, it2, comparator);
        return result;
    }
}

