/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;

public class CollectionUtils {
    public static <T, C extends Collection<T>> C newCollection(Supplier<C> collectionSupplier, Iterator<? extends T> itemIt) {
        Collection result = (Collection)collectionSupplier.get();
        while (itemIt.hasNext()) {
            T item = itemIt.next();
            result.add(item);
        }
        return (C)result;
    }

    public static <T, C extends Collection<T>> C newCollection(Supplier<C> collectionSupplier, Iterable<? extends T> items) {
        return CollectionUtils.newCollection(collectionSupplier, items.iterator());
    }

    public static <S, T extends Iterable<S>> Iterable<S> safeGetFirst(Iterable<T> iterable) {
        Iterator<T> it = iterable.iterator();
        return it.hasNext() ? (Iterable)it.next() : Collections.emptySet();
    }

    public static <T> List<List<T>> chunk(Iterable<T> col, int batchSize) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        ArrayList<T> chunk = new ArrayList<T>();
        Iterator<T> it = col.iterator();
        while (it.hasNext()) {
            chunk.add(it.next());
            if (chunk.size() < batchSize && it.hasNext()) continue;
            result.add(chunk);
            if (!it.hasNext()) continue;
            chunk = new ArrayList();
        }
        return result;
    }

    static <T> Set<T> asSet(T[] a) {
        HashSet<T> s = new HashSet<T>();
        for (T e : a) {
            s.add(e);
        }
        return s;
    }

    public static <T> Optional<T> argmaxInt(Collection<T> xs, ToIntFunction<? super T> score) {
        return xs.stream().max(Comparator.comparingInt(score::applyAsInt));
    }
}

