/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collection.observable;

import com.google.common.collect.Sets;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.aksw.commons.collection.observable.CollectionChangedEvent;
import org.aksw.commons.collection.observable.CollectionChangedEventImpl;
import org.aksw.commons.collection.observable.ObservableSet;
import org.aksw.commons.collection.observable.ObservableSetImpl;
import org.aksw.commons.collection.observable.Registration;

public class ObservableSetDifference<T>
extends AbstractSet<T>
implements ObservableSet<T> {
    protected ObservableSet<T> lhs;
    protected ObservableSet<T> rhs;
    protected Set<T> effectiveSet;

    public ObservableSetDifference(ObservableSet<T> lhs, ObservableSet<T> rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.effectiveSet = Sets.difference(lhs, rhs);
    }

    @Override
    public boolean delta(Collection<? extends T> additions, Collection<?> removals) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Runnable addVetoableChangeListener(VetoableChangeListener listener) {
        Runnable a = this.lhs.addVetoableChangeListener(ObservableSetDifference.convertVetoableChangeListener(this, this.rhs, listener));
        Runnable b = this.rhs.addVetoableChangeListener(ObservableSetDifference.convertVetoableChangeListener(this, this.lhs, listener));
        return () -> {
            a.run();
            b.run();
        };
    }

    @Override
    public Registration addPropertyChangeListener(PropertyChangeListener listener) {
        Registration a = this.lhs.addPropertyChangeListener(ObservableSetDifference.convertPropertyChangeListener(this, this.rhs, listener));
        Registration b = this.rhs.addPropertyChangeListener(ObservableSetDifference.convertPropertyChangeListener(this, this.lhs, listener));
        return Registration.from(() -> listener.propertyChange(new CollectionChangedEventImpl(this, this, this, Collections.emptySet(), Collections.emptySet(), Collections.emptySet())), () -> {
            a.remove();
            b.remove();
        });
    }

    public static <T> VetoableChangeListener convertVetoableChangeListener(Object self, Set<T> other, VetoableChangeListener listener) {
        return ev -> {
            CollectionChangedEvent newEv = ObservableSetDifference.convertEvent(self, (CollectionChangedEvent)ev, other);
            if (newEv.hasChanges()) {
                listener.vetoableChange(newEv);
            }
        };
    }

    public static <T> PropertyChangeListener convertPropertyChangeListener(Object self, Set<T> other, PropertyChangeListener listener) {
        return ev -> {
            CollectionChangedEvent newEv = ObservableSetDifference.convertEvent(self, (CollectionChangedEvent)ev, other);
            if (newEv.hasChanges()) {
                listener.propertyChange(newEv);
            }
        };
    }

    protected static <T> Set<T> nullSafeDifference(Set<T> set, Set<T> other) {
        return set == null ? Collections.emptySet() : Sets.difference(set, other);
    }

    public static <T> CollectionChangedEvent<T> convertEvent(Object self, CollectionChangedEvent<T> ev, Set<T> other) {
        Set<T> effectiveAdditions = ObservableSetDifference.nullSafeDifference((Set)ev.getAdditions(), other);
        Set<T> effectiveDeletions = ObservableSetDifference.nullSafeDifference((Set)ev.getDeletions(), other);
        return new CollectionChangedEventImpl<T>(self, self, Sets.union((Set)Sets.difference((Set)((Set)self), effectiveDeletions), effectiveAdditions), effectiveAdditions, effectiveDeletions, ObservableSetDifference.nullSafeDifference((Set)ev.getRefreshes(), other));
    }

    @Override
    public Iterator<T> iterator() {
        return this.effectiveSet.iterator();
    }

    @Override
    public int size() {
        return this.effectiveSet.size();
    }

    public static <T> ObservableSet<T> create(ObservableSet<T> a, ObservableSet<T> b) {
        return new ObservableSetDifference<T>(a, b);
    }

    public static void main(String[] args) {
        ObservableSet<String> a = ObservableSetImpl.decorate(new LinkedHashSet());
        ObservableSet<String> b = ObservableSetImpl.decorate(new LinkedHashSet());
        ObservableSet c = ObservableSetDifference.create(a, b);
        c.addPropertyChangeListener(ev -> System.out.println(ev));
        a.add("Hello");
        b.add("Hello");
        a.remove("Hello");
        b.remove("Hello");
    }
}

