/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collection.observable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.Map;
import java.util.Objects;
import org.aksw.commons.collection.observable.ObservableSet;
import org.aksw.commons.collection.observable.ObservableValue;
import org.aksw.commons.collection.observable.Registration;

public interface ObservableMap<K, V>
extends Map<K, V> {
    @Override
    public ObservableSet<K> keySet();

    public Runnable addVetoableChangeListener(VetoableChangeListener var1);

    public Registration addPropertyChangeListener(PropertyChangeListener var1);

    default public ObservableValue<V> observeKey(K key) {
        return this.observeKey(key, null);
    }

    default public ObservableValue<V> observeKey(final K key, final V defaultValue) {
        return new ObservableValue<V>(){
            final /* synthetic */ ObservableMap this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public V get() {
                return this.this$0.getOrDefault(key, defaultValue);
            }

            @Override
            public void set(V value) {
                if (value == null) {
                    this.this$0.remove(key);
                } else {
                    this.this$0.put(key, value);
                }
            }

            @Override
            public Registration addPropertyChangeListener(PropertyChangeListener listener) {
                return this.this$0.addPropertyChangeListener(ev -> {
                    Object oldValue = ((Map)ev.getOldValue()).getOrDefault(key, defaultValue);
                    Object newValue = ((Map)ev.getNewValue()).getOrDefault(key, defaultValue);
                    if (oldValue != null && newValue != null && !Objects.equals(oldValue, newValue)) {
                        listener.propertyChange(new PropertyChangeEvent(this, "value", oldValue, newValue));
                    }
                });
            }

            @Override
            public Runnable addVetoableChangeListener(VetoableChangeListener listener) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

