/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.slot;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aksw.commons.util.slot.Slot;
import org.aksw.commons.util.slot.SlottedBuilder;

public class SlottedBuilderImpl<W, P>
implements SlottedBuilder<W, P> {
    protected Function<Collection<P>, ? extends W> assembler;
    protected Set<Slot<P>> slots = new LinkedHashSet<Slot<P>>();

    public SlottedBuilderImpl(Function<Collection<P>, ? extends W> assembler) {
        this.assembler = assembler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Slot<P> newSlot() {
        SlotImpl result = new SlotImpl();
        Set<Slot<P>> set = this.slots;
        synchronized (set) {
            this.slots.add(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public W build() {
        Set<Slot<P>> set = this.slots;
        synchronized (set) {
            Collection parts = this.slots.stream().filter(slot -> slot != null).map(Slot::getSupplier).filter(supplier -> supplier != null).map(Supplier::get).filter(part -> part != null).collect(Collectors.toList());
            W result = this.assembler.apply(parts);
            return result;
        }
    }

    public static <W, P> SlottedBuilder<W, P> create(Function<Collection<P>, ? extends W> assembler) {
        return new SlottedBuilderImpl<W, P>(assembler);
    }

    public class SlotImpl
    implements Slot<P> {
        protected Supplier<P> supplier;

        @Override
        public Supplier<P> getSupplier() {
            return this.supplier;
        }

        @Override
        public Slot<P> setSupplier(Supplier<P> partSupplier) {
            this.supplier = partSupplier;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Set set = SlottedBuilderImpl.this.slots;
            synchronized (set) {
                SlottedBuilderImpl.this.slots.remove(this);
            }
        }

        public String toString() {
            return "SlotImpl [suppliedValue=" + String.valueOf(this.supplier.get()) + "]";
        }
    }
}

