/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.sets;

import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.aksw.commons.collections.sets.SetIterator;

public class SetFromCollection<T>
extends AbstractSet<T> {
    protected Collection<T> backend;

    public SetFromCollection(Collection<T> backend) {
        this.backend = backend;
    }

    @Override
    public boolean add(T e) {
        boolean result = this.backend.contains(e) ? false : this.backend.add(e);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = false;
        while (this.backend.remove(o)) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean contains(Object o) {
        boolean result = this.backend.contains(o);
        return result;
    }

    @Override
    public void clear() {
        this.backend.clear();
    }

    @Override
    public Iterator<T> iterator() {
        SetIterator<T> result = new SetIterator<T>(this.backend);
        return result;
    }

    @Override
    public int size() {
        int result = Iterators.size(this.iterator());
        return result;
    }

    public static <T> Set<T> wrapIfNeeded(Collection<T> collection) {
        Set<Object> result = collection instanceof Set ? (Set<Object>)collection : new SetFromCollection<T>(collection);
        return result;
    }
}

