/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.selector;

import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import org.aksw.commons.collections.selector.WeightedSelector;
import org.aksw.commons.collections.selector.WeightedSelectorMutable;

public class WeightedSelectorImmutable<T>
implements WeightedSelector<T> {
    protected NavigableMap<Double, Map.Entry<T, ? extends Number>> offsetToEntry;
    protected double nextOffset;

    @Override
    public WeightedSelectorImmutable<T> clone() {
        return this;
    }

    public WeightedSelectorImmutable(NavigableMap<Double, Map.Entry<T, ? extends Number>> offsetToEntry, double nextOffset) {
        this.nextOffset = nextOffset;
        this.offsetToEntry = offsetToEntry;
    }

    @Override
    public Map.Entry<T, ? extends Number> sampleEntry(Number t) {
        double d = Objects.requireNonNull(t).doubleValue();
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Argument must be in the interval [0, 1]");
        }
        double key = d * this.nextOffset;
        Map.Entry<T, Number> result = this.offsetToEntry == null || this.offsetToEntry.isEmpty() ? null : this.offsetToEntry.floorEntry(key).getValue();
        return result;
    }

    public static <X, T> WeightedSelectorImmutable<T> create(Iterable<? extends Map.Entry<T, ? extends Number>> entries) {
        return WeightedSelectorImmutable.create(entries, Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T> WeightedSelectorImmutable<T> create(Map<T, ? extends Number> map) {
        return WeightedSelectorImmutable.create(map.entrySet());
    }

    public static <T> WeightedSelectorImmutable<T> create(Iterable<T> items, Function<? super T, ? extends Number> getWeight) {
        return WeightedSelectorImmutable.create(items, Functions.identity(), getWeight);
    }

    public static <X, T> WeightedSelectorImmutable<T> create(Iterable<X> items, Function<? super X, ? extends T> getEntity, Function<? super X, ? extends Number> getWeight) {
        TreeMap<Double, Map.Entry<T, Number>> offsetToEntry = new TreeMap<Double, Map.Entry<T, Number>>();
        double nextOffset = 0.0;
        for (X item : items) {
            T entity = getEntity.apply(item);
            double itemWeight = getWeight.apply(item).doubleValue();
            Map.Entry e = Maps.immutableEntry(entity, (Object)itemWeight);
            if (itemWeight < 0.0) {
                throw new RuntimeException("Item weights must be >= 0, encountered: " + String.valueOf(e));
            }
            offsetToEntry.put(nextOffset, e);
            nextOffset += WeightedSelectorMutable.eps(itemWeight);
        }
        WeightedSelectorImmutable<T> result = new WeightedSelectorImmutable<T>(offsetToEntry, nextOffset);
        return result;
    }

    @Override
    public Collection<Map.Entry<T, ? extends Number>> entries() {
        return this.offsetToEntry.values();
    }
}

