/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.generator;

import java.util.function.Function;
import org.aksw.commons.collections.generator.Generator;

public class GeneratorFromFunction<T>
implements Generator<T> {
    protected T current;
    protected Function<? super T, ? extends T> inc;

    public GeneratorFromFunction(T current, Function<? super T, ? extends T> inc) {
        this.current = current;
        this.inc = inc;
    }

    @Override
    public T next() {
        this.current = this.inc.apply(this.current);
        return this.current;
    }

    @Override
    public T current() {
        return this.current;
    }

    @Override
    public Generator<T> clone() {
        return new GeneratorFromFunction<T>(this.current, this.inc);
    }

    public static <T> GeneratorFromFunction<T> create(T current, Function<? super T, ? extends T> inc) {
        return new GeneratorFromFunction<T>(current, inc);
    }

    public static GeneratorFromFunction<Integer> createInt() {
        return GeneratorFromFunction.createInt(0);
    }

    public static GeneratorFromFunction<Integer> createInt(int initialNext) {
        return GeneratorFromFunction.create(initialNext - 1, Math::incrementExact);
    }
}

