/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.cluster;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collections.generator.GeneratorLending;
import org.aksw.commons.collections.generator.GeneratorLendingImpl;

public class IndirectEquiMap<K, V> {
    protected Map<K, Integer> keyToToken = new HashMap<K, Integer>();
    protected Multimap<Integer, K> tokenToKeys = LinkedHashMultimap.create();
    protected Map<Integer, V> tokenToValue = new HashMap<Integer, V>();
    protected Multimap<Integer, K> tokenToKeysView = Multimaps.unmodifiableMultimap(this.tokenToKeys);
    protected GeneratorLending<Integer> gen = GeneratorLendingImpl.createInt();

    public Map<Set<K>, V> dump() {
        Map<Set, Object> result = this.tokenToKeys.asMap().entrySet().stream().collect(Collectors.toMap(e -> (Set)e.getValue(), e -> this.tokenToValue.get(e.getKey())));
        return result;
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.keyToToken.keySet());
    }

    public Multimap<Integer, K> getEquivalences() {
        return this.tokenToKeysView;
    }

    public V getValue(Integer token) {
        return this.tokenToValue.get(token);
    }

    public V setValue(Integer token, V value) {
        boolean isValidToken = this.tokenToKeys.containsKey((Object)token);
        if (!isValidToken) {
            throw new RuntimeException("There is no cluster of keys with id " + token);
        }
        IndirectEquiMap.putWithoutNull(this.tokenToValue, token, value);
        return value;
    }

    public Collection<K> getEquivalences(K key) {
        Integer token = this.keyToToken.get(key);
        Collection result = this.tokenToKeys.get((Object)token);
        return result;
    }

    protected void putKeyToken(K key, int token) {
        this.keyToToken.put(key, token);
        this.tokenToKeys.put((Object)token, key);
    }

    public Map.Entry<V, V> tryStateEqual(K a, K b) {
        Map.Entry<Object, Object> result = this.tryStateEqual(a, b, null, false);
        return result;
    }

    public void stateEqual(K a, K b) {
        Map.Entry<V, V> conflict = this.tryStateEqual(a, b);
        if (conflict != null) {
            throw new RuntimeException("Cannot make " + String.valueOf(a) + " and " + String.valueOf(b) + " equal due to conflicting values: " + String.valueOf(conflict));
        }
    }

    public void stateEqual(K a, K b, V value) {
        this.tryStateEqual(a, b, value, true);
    }

    public void stateEqual(Collection<K> keys, V value) {
        int newToken = (Integer)this.gen.next();
        for (K key : keys) {
            Integer oldToken = this.keyToToken.get(key);
            if (oldToken != null) {
                this.gen.giveBack(oldToken);
                this.tokenToValue.remove(oldToken);
                this.tokenToKeys.putAll((Object)newToken, (Iterable)this.tokenToKeys.get((Object)oldToken));
                this.tokenToKeys.removeAll((Object)oldToken);
            }
            this.putKeyToken(key, newToken);
        }
        this.tokenToValue.put(newToken, value);
    }

    protected Map.Entry<V, V> tryStateEqual(K a, K b, V value, boolean overwrite) {
        Integer ta = this.keyToToken.get(a);
        Integer tb = this.keyToToken.get(b);
        if (ta == null) {
            if (tb == null) {
                int token = (Integer)this.gen.next();
                this.putKeyToken(a, token);
                this.putKeyToken(b, token);
            } else {
                this.putKeyToken(a, tb);
            }
        } else if (tb == null) {
            this.putKeyToken(b, ta);
        } else {
            V va = this.tokenToValue.get(ta);
            V vb = this.tokenToValue.get(tb);
            if (va != null && vb != null && !va.equals(vb)) {
                if (overwrite) {
                    va = value;
                } else {
                    return Maps.immutableEntry(va, vb);
                }
            }
            if (va == null) {
                va = vb;
            }
            ArrayList ka = new ArrayList(this.tokenToKeys.get((Object)ta));
            ArrayList kb = new ArrayList(this.tokenToKeys.get((Object)tb));
            boolean mergeSmallerClusterIntoLangerOne = false;
            if (mergeSmallerClusterIntoLangerOne && kb.size() > ka.size()) {
                ArrayList tmp = ka;
                ka = kb;
                kb = tmp;
                int tt = ta;
                ta = tb;
                tb = tt;
            }
            this.tokenToKeys.removeAll((Object)tb);
            this.tokenToValue.remove(tb);
            this.gen.giveBack(tb);
            for (Object k : kb) {
                this.putKeyToken(k, ta);
            }
            IndirectEquiMap.putWithoutNull(this.tokenToValue, ta, va);
        }
        return null;
    }

    public static <K, V> void putWithoutNull(Map<K, V> map, K key, V value) {
        if (value == null) {
            map.remove(key);
        } else {
            map.put(key, value);
        }
    }

    public void add(K key) {
        this.addKey(key);
    }

    public void put(K key, V value) {
        Integer token = this.addKey(key);
        IndirectEquiMap.putWithoutNull(this.tokenToValue, token, value);
    }

    protected Integer addKey(K key) {
        Integer token = this.keyToToken.get(key);
        if (token == null) {
            token = (Integer)this.gen.next();
            this.keyToToken.put(key, token);
        }
        this.tokenToKeys.put((Object)token, key);
        return token;
    }

    public V get(K key) {
        Integer token = this.keyToToken.get(key);
        V result = token == null ? null : (V)this.tokenToValue.get(token);
        return result;
    }

    public boolean isEqual(K a, K b) {
        Integer ta = this.keyToToken.get(a);
        boolean result = ta != null && ta.equals(this.keyToToken.get(b));
        return result;
    }

    public String toString() {
        Object result = "[";
        boolean isFirst = true;
        for (Map.Entry entry : this.tokenToKeys.asMap().entrySet()) {
            if (!isFirst) {
                result = (String)result + ", ";
            }
            result = (String)result + String.valueOf(entry.getValue()) + ": " + String.valueOf(this.tokenToValue.get(entry.getKey()));
            isFirst = false;
        }
        result = (String)result + "]";
        return result;
    }
}

