/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.io.Closeable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class SinglePrefetchIterator<T>
implements Iterator<T>,
Closeable {
    private T current = null;
    private boolean finished = false;
    private boolean advance = true;
    private boolean wasNextCalled = false;

    protected abstract T prefetch() throws Exception;

    protected SinglePrefetchIterator() {
    }

    protected T finish() {
        this.finished = true;
        this.close();
        return null;
    }

    private void _prefetch() {
        try {
            this.current = this.prefetch();
        }
        catch (Exception e) {
            this.current = null;
            throw new RuntimeException("Prefetching data failed. Reason: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean hasNext() {
        this.wasNextCalled = false;
        if (this.advance) {
            this._prefetch();
            this.advance = false;
        }
        return !this.finished;
    }

    @Override
    public T next() {
        this.wasNextCalled = true;
        if (this.finished) {
            throw new NoSuchElementException();
        }
        if (this.advance) {
            this._prefetch();
        }
        this.advance = true;
        return this.current;
    }

    public T current() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.current;
        return result;
    }

    protected boolean willAdvance() {
        return this.advance;
    }

    protected boolean wasNextCalled() {
        return this.wasNextCalled;
    }

    protected boolean wasHasNextCalled() {
        return !this.finished && !this.wasNextCalled && !this.advance;
    }

    @Override
    public void close() {
    }

    @Override
    public final void remove() {
        if (!this.wasNextCalled) {
            throw new RuntimeException("remove must not be called after .hasNext() - invoke .next() first");
        }
        this.doRemove(this.current);
    }

    protected void doRemove(T item) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

