/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.io.Closeable;
import java.util.Iterator;

public abstract class PrefetchIterator<T>
implements Iterator<T>,
Closeable {
    private Iterator<T> current = null;
    private boolean finished = false;

    protected abstract Iterator<T> prefetch() throws Exception;

    protected PrefetchIterator() {
    }

    private void preparePrefetch() {
        if (this.finished) {
            return;
        }
        this.current = null;
        Throwable x = null;
        try {
            do {
                this.current = this.prefetch();
            } while (this.current != null && !this.current.hasNext());
        }
        catch (Throwable e) {
            this.current = null;
            x = e;
        }
        if (this.current == null) {
            this.close();
            this.finished = true;
            if (x != null) {
                throw new RuntimeException(x);
            }
        }
    }

    private Iterator<T> getCurrent() {
        if (this.current == null || !this.current.hasNext()) {
            this.preparePrefetch();
        }
        return this.current;
    }

    @Override
    public boolean hasNext() {
        return this.getCurrent() != null;
    }

    @Override
    public T next() {
        return this.getCurrent().next();
    }

    @Override
    public void close() {
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

