/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class PolaritySet<T>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Set<T> values;
    protected boolean isPositive;

    public PolaritySet(Set<T> values) {
        this.values = values;
        this.isPositive = true;
    }

    public PolaritySet(boolean isPositive, Set<T> values) {
        this.values = values;
        this.isPositive = isPositive;
    }

    protected PolaritySet<T> clone() {
        return new PolaritySet<T>(this.isPositive, new LinkedHashSet<T>(this.values));
    }

    public static <T> PolaritySet<T> create(boolean isPositive, T ... values) {
        LinkedHashSet<T> v = new LinkedHashSet<T>(Arrays.asList(values));
        PolaritySet<T> result = new PolaritySet<T>(isPositive, v);
        return result;
    }

    public PolaritySet<T> union(PolaritySet<T> that) {
        return PolaritySet.createUnionView(this, that);
    }

    public PolaritySet<T> intersect(PolaritySet<T> that) {
        return PolaritySet.createIntersectionView(this, that);
    }

    public PolaritySet<T> difference(PolaritySet<T> that) {
        return PolaritySet.createDifferenceView(this, that);
    }

    public PolaritySet<T> negate() {
        PolaritySet<T> result = new PolaritySet<T>(!this.isPositive, this.values);
        return result;
    }

    public boolean isEmpty() {
        return this.isPositive && this.values.isEmpty();
    }

    public boolean contains(Object item) {
        boolean isContained = this.values.contains(item);
        boolean result = this.isPositive ? isContained : !isContained;
        return result;
    }

    public boolean isPositive() {
        return this.isPositive;
    }

    public boolean setPolarity(boolean isPositive) {
        boolean result = isPositive;
        this.isPositive = isPositive;
        return result;
    }

    public Set<T> getValue() {
        return this.values;
    }

    public void clear() {
        this.values.clear();
        this.isPositive = true;
    }

    public String toString() {
        String polarity = this.isPositive ? "+" : "-";
        return polarity + String.valueOf(this.values);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isPositive ? 1231 : 1237);
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PolaritySet other = (PolaritySet)obj;
        if (this.isPositive != other.isPositive) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public PolaritySet<T> stateIntersect(PolaritySet<T> that) {
        if (this.isPositive) {
            if (that.isPositive) {
                this.values.retainAll(that.values);
            } else {
                this.values.removeAll(that.values);
            }
        } else if (that.isPositive) {
            this.values = new HashSet<T>(Sets.difference(that.values, this.values));
            this.isPositive = true;
        } else {
            this.values.addAll(that.values);
        }
        return this;
    }

    public PolaritySet<T> stateUnion(PolaritySet<T> that) {
        if (this.isPositive) {
            if (that.isPositive) {
                this.values.addAll(that.values);
            } else {
                this.values = new HashSet<T>(Sets.difference(that.values, this.values));
                this.isPositive = false;
            }
        } else if (that.isPositive) {
            this.values.removeAll(that.values);
            this.isPositive = false;
        } else {
            this.values.retainAll(that.values);
        }
        return this;
    }

    public PolaritySet<T> stateNegate() {
        this.isPositive = !this.isPositive;
        return this;
    }

    public static <T> PolaritySet<T> createDifferenceView(PolaritySet<T> self, PolaritySet<T> that) {
        throw new RuntimeException("not implemented yet");
    }

    public static <T> PolaritySet<T> createIntersectionView(PolaritySet<T> self, PolaritySet<T> that) {
        Sets.SetView set;
        boolean isPos = true;
        if (self.isPositive) {
            set = that.isPositive ? Sets.intersection(self.values, that.values) : Sets.difference(self.values, that.values);
        } else if (that.isPositive) {
            set = Sets.difference(that.values, self.values);
        } else {
            set = Sets.union(self.values, that.values);
            isPos = false;
        }
        PolaritySet<T> result = new PolaritySet<T>(isPos, set);
        return result;
    }

    public static <T> PolaritySet<T> createUnionView(PolaritySet<T> self, PolaritySet<T> that) {
        Sets.SetView set;
        boolean isPos = true;
        if (self.isPositive) {
            if (that.isPositive) {
                set = Sets.union(self.values, that.values);
            } else {
                set = Sets.difference(that.values, self.values);
                isPos = false;
            }
        } else if (that.isPositive) {
            set = Sets.difference(self.values, that.values);
            isPos = false;
        } else {
            set = Sets.intersection(self.values, that.values);
        }
        PolaritySet<T> result = new PolaritySet<T>(isPos, set);
        return result;
    }
}

