/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.aksw.commons.collections.IteratorIterable;

public class IteratorUtils {
    public static <T> Iterable<T> makeIterable(Iterator<T> iterator) {
        return new IteratorIterable<T>(iterator);
    }

    public static <T> T expectOneItem(Iterator<T> iterator) {
        T result = null;
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Exactly one item expected in stream; got none");
        }
        result = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("Exactly one item expected in stream; got multiple");
        }
        return result;
    }

    public static <T> T expectZeroOrOneItems(Iterator<T> iterator) {
        T result = !iterator.hasNext() ? null : (T)IteratorUtils.expectOneItem(iterator);
        return result;
    }

    public static <T> Iterator<T> limit(final Iterator<T> iterator, final long limitSize) {
        Objects.requireNonNull(iterator);
        return new Iterator<T>(){
            protected long count;

            @Override
            public boolean hasNext() {
                return this.count < limitSize && iterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <X> int compare(Iterator<? extends X> it1, Iterator<? extends X> it2, Comparator<X> comparator) {
        while (it1.hasNext()) {
            X item2;
            if (!it2.hasNext()) {
                return 1;
            }
            X item1 = it1.next();
            int d = comparator.compare(item1, item2 = it2.next());
            if (d == 0) continue;
            return d;
        }
        if (it2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static boolean equalsByReference(Iterator<?> it1, Iterator<?> it2) {
        int val = IteratorUtils.compare(it1, it2, (x, y) -> x == y ? 0 : -1);
        return val == 0;
    }
}

